/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.util;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.util.FileBasedPersistedResultSet;
import com.cognos.xqe.runtree.relational.util.HashKeysSet;
import java.util.HashSet;

public class DuplicateEliminator
extends XTabularIterator {
    private static final int INITIAL_CAPACITY = 1000;
    private HashSet<HashKeysSet> hashSet;
    private long memory = 0L;
    private XTabularIterator tabIt = null;
    private IRowsetInfo iResultSetInfo = null;
    private IRow result;
    private IRow inputRow;
    private HashKeysSet inputRowKeys = null;

    public DuplicateEliminator(XDataContext context, XTabularIterator theInputIterator, IRowsetInfo theIResultSetInfo) {
        super(context, new Integer(-1));
        this.tabIt = theInputIterator;
        this.iResultSetInfo = theIResultSetInfo;
        this.hashSet = new HashSet(1000);
        this.inputRowKeys = new HashKeysSet(this.iResultSetInfo.getNumColumns(), context.getLocalCollator(), true);
    }

    @Override
    public Object nextImpl() {
        while (true) {
            boolean forced;
            try {
                this.inputRow = (IRow)this.tabIt.next();
            }
            catch (OperationCanceledException e) {
                this.release();
                throw e;
            }
            if (this.inputRow == null) {
                this.tabIt.release();
                this.tabIt = null;
                return null;
            }
            this.inputRowKeys.set(this.inputRow);
            boolean exists = this.hashSet.contains(this.inputRowKeys);
            if (exists) continue;
            long memRequired = this.inputRowKeys.sizeOf();
            boolean bl = forced = this.hashSet.size() == 0;
            if (this.context.getMemoryManager().allocateMemory(memRequired, forced)) {
                this.hashSet.add(this.inputRowKeys.copy());
                this.memory += memRequired;
                break;
            }
            this.makeScan();
        }
        this.result = this.inputRow;
        ++this.nRows;
        return this.result;
    }

    private void makeScan() {
        FileBasedPersistedResultSet scan = new FileBasedPersistedResultSet(this.iResultSetInfo.getDataType(), this.context);
        block2: do {
            scan.write(this.inputRow);
            do {
                try {
                    this.inputRow = (IRow)this.tabIt.next();
                }
                catch (XQERuntimeException e) {
                    scan.release();
                    throw e;
                }
                if (this.inputRow == null) continue block2;
                this.inputRowKeys.set(this.inputRow);
            } while (this.hashSet.contains(this.inputRowKeys));
        } while (this.inputRow != null);
        this.tabIt.release();
        this.tabIt = scan.getIterator();
        this.hashSet.clear();
        if (this.memory > 0L) {
            this.context.getMemoryManager().releaseMemory(this.memory);
            this.memory = 0L;
        }
    }

    @Override
    public long getIndex() {
        return -1L;
    }

    @Override
    public void release() {
        if (this.tabIt != null) {
            this.tabIt.release();
            this.tabIt = null;
        }
        this.result = null;
        this.inputRow = null;
        this.hashSet = null;
        if (this.memory > 0L) {
            this.context.getMemoryManager().releaseMemory(this.memory);
            this.memory = 0L;
        }
        super.release();
    }
}

