/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.util;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.values.IEncodable;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.util.FileBasedPersistedResultSet;
import com.cognos.xqe.runtree.relational.util.IPersistedResultSet;
import gnu.trove.map.hash.THashMap;
import java.util.Iterator;
import java.util.Map;

public class DuplicateValueEliminator {
    private Map<Object, IValue> hashMap;
    private long memory = 0L;
    private XDataContext context;
    private Iterator<IValue> iterator = null;
    private IPersistedResultSet scan = null;

    public DuplicateValueEliminator(XDataContext theContext) {
        this.context = theContext;
        this.hashMap = new THashMap();
    }

    public void write(IValue value) {
        if (this.context.isCanceled()) {
            throw new OperationCanceledException(this.context.getCancelSource());
        }
        Object hashKey = value.hashKey();
        boolean exists = this.hashMap.containsKey(hashKey);
        if (!exists) {
            boolean forced;
            if (this.scan != null) {
                this.scan.write((IEncodable)((Object)value));
                return;
            }
            long memRequired = value.sizeOf();
            boolean bl = forced = this.hashMap.size() == 0;
            if (this.context.getMemoryManager().allocateMemory(memRequired, forced)) {
                IValue v = (IValue)value.copy();
                this.hashMap.put(v.hashKey(), v);
                this.memory += memRequired;
            } else {
                this.scan = new FileBasedPersistedResultSet(value.getDataType(), this.context);
                this.scan.write((IEncodable)((Object)value));
            }
        }
    }

    public IValue next() {
        if (this.iterator == null) {
            this.iterator = this.hashMap.values().iterator();
        }
        if (this.iterator.hasNext()) {
            return this.iterator.next();
        }
        if (this.scan != null) {
            IValue value;
            IPersistedResultSet resultSet = this.scan;
            this.context.getMemoryManager().releaseMemory(this.memory);
            this.hashMap.clear();
            XTabularIterator it = this.scan.getIterator();
            this.scan = null;
            while ((value = (IValue)it.next()) != null) {
                this.write(value);
            }
            it.release();
            resultSet.release();
            this.iterator = null;
            return this.next();
        }
        return null;
    }

    public void release() {
        if (this.scan != null) {
            this.scan.release();
        }
        if (this.memory > 0L) {
            this.context.getMemoryManager().releaseMemory(this.memory);
        }
        this.hashMap.clear();
    }
}

