/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.util;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IEncodable;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.util.IPersistedResultSet;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorTabularIterator;
import com.cognos.xqe.util.io.BufferedDataInputStream;
import com.cognos.xqe.util.io.BufferedDataOutputStream;
import com.cognos.xqe.util.io.TempFileUtil;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;

public class FileBasedPersistedResultSet
implements IPersistedResultSet {
    private IDataType dataType;
    private XDataContext context;
    private BufferedDataOutputStream oStream = null;
    private File file;
    private long position = 0L;
    private boolean immutable = false;
    private boolean releaseResultSetFlag = true;
    private int iterators = 0;

    public FileBasedPersistedResultSet(IDataType theDataType, XDataContext theContext) {
        this.context = theContext;
        this.dataType = theDataType;
    }

    public FileBasedPersistedResultSet(IDataType theDataType, XDataContext theContext, boolean releaseResultSet) {
        this.context = theContext;
        this.dataType = theDataType;
        this.releaseResultSetFlag = releaseResultSet;
    }

    @Override
    public long write(IEncodable value) {
        if (this.immutable) {
            throw new RuntimeException("Attempt to write to closed result set");
        }
        try {
            if (this.oStream == null) {
                this.file = TempFileUtil.createTempFile(this.getClass().getSimpleName());
                this.oStream = new BufferedDataOutputStream(this.file);
            }
            value.encode(this.context, this.oStream);
            long retval = this.position;
            this.position = this.oStream.getPosition();
            return retval;
        }
        catch (Exception e) {
            this.release();
            throw new XQERuntimeException(e);
        }
    }

    public XVectorTabularIterator getVectorizedIterator(IRowsetInfo rowsetInfo, XVectorContext vContext) {
        return this.getVectorizedIterator(0L, rowsetInfo, vContext, true);
    }

    public XVectorTabularIterator getVectorizedIterator(long address, IRowsetInfo rowsetInfo, XVectorContext vContext, boolean reUseBatchObject) {
        if (!this.immutable) {
            try {
                if (this.oStream != null) {
                    this.oStream.flush();
                    this.oStream.close();
                    this.oStream = null;
                }
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
            this.immutable = true;
        }
        FileBasedPersistedVectorizedResultSetIterator iter = new FileBasedPersistedVectorizedResultSetIterator(this.context, address, rowsetInfo, vContext, reUseBatchObject, this.iterators);
        ++this.iterators;
        return iter;
    }

    @Override
    public XTabularIterator getIterator() {
        return this.getIterator(0L);
    }

    @Override
    public XTabularIterator getIterator(long address) {
        if (!this.immutable) {
            try {
                this.oStream.flush();
                this.oStream.close();
                this.oStream = null;
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
            this.immutable = true;
        }
        FileBasedPersistedResultSetIterator iter = new FileBasedPersistedResultSetIterator(this.context, address, this.iterators);
        ++this.iterators;
        return iter;
    }

    @Override
    public void release() {
        if (this.iterators > 0) {
            throw new XQERuntimeException(new RuntimeException("Not all iterators are released."));
        }
        if (this.file != null) {
            if (!this.immutable && this.oStream != null) {
                try {
                    this.oStream.close();
                    this.oStream = null;
                }
                catch (IOException e) {
                    throw new XQERuntimeException(e);
                }
            }
            TempFileUtil.deleteTempFile(this.file);
            this.file = null;
        }
    }

    public String getFileName() {
        if (this.file == null) {
            return null;
        }
        return this.file.getName();
    }

    private class FileBasedPersistedVectorizedResultSetIterator
    extends XVectorTabularIterator {
        private BufferedDataInputStream iStream;
        private boolean reuseBatch;

        FileBasedPersistedVectorizedResultSetIterator(XDataContext theContext, long start, IRowsetInfo rowSetInfo, XVectorContext vContext, boolean reUseBatchObject, int iterators) {
            super(theContext, theContext.getNodeId(), rowSetInfo);
            this.iStream = null;
            this.batch = XVectorRowBatchUtil.createRowBatch(vContext, rowSetInfo, theContext.getLocalCollator());
            this.reuseBatch = reUseBatchObject;
            if (FileBasedPersistedResultSet.this.file != null) {
                try {
                    this.iStream = new BufferedDataInputStream(FileBasedPersistedResultSet.this.file, iterators);
                    if (start > 0L) {
                        this.iStream.seek(start);
                    }
                }
                catch (IOException e) {
                    throw new XQERuntimeException(e);
                }
            }
        }

        @Override
        public Object nextBatch() {
            try {
                if (this.reuseBatch) {
                    this.batch.reset();
                } else {
                    this.batch = XVectorRowBatchUtil.copyRowBatchStructure(this.batch, this.batch.maxBatchSize);
                }
                if (this.iStream != null) {
                    this.batch.decode(this.context, this.iStream);
                } else {
                    this.batch.eod = true;
                }
            }
            catch (IOException e) {
                if (e instanceof EOFException) {
                    this.batch.eod = true;
                    return this.batch;
                }
                throw new XQERuntimeException(e);
            }
            return this.batch;
        }

        @Override
        public void release() {
            try {
                if (this.iStream != null) {
                    this.iStream.close();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.iStream = null;
            }
            this.batch = null;
            super.release();
            FileBasedPersistedResultSet.this.iterators--;
            if (FileBasedPersistedResultSet.this.iterators == 0 && FileBasedPersistedResultSet.this.releaseResultSetFlag) {
                FileBasedPersistedResultSet.this.release();
            }
        }
    }

    private class FileBasedPersistedResultSetIterator
    extends XTabularIterator {
        private BufferedDataInputStream iStream;
        private Value value;

        FileBasedPersistedResultSetIterator(XDataContext theContext, long start, int iterators) {
            super(theContext, theContext.getNodeId());
            this.iStream = null;
            this.value = null;
            this.value = (Value)FileBasedPersistedResultSet.this.dataType.createValue(this.context.getLocalCollator());
            try {
                this.iStream = new BufferedDataInputStream(FileBasedPersistedResultSet.this.file, iterators);
                if (start > 0L) {
                    this.iStream.seek(start);
                }
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
        }

        @Override
        public Object nextImpl() {
            try {
                this.value.decode(this.context, this.iStream);
            }
            catch (IOException e) {
                if (e instanceof EOFException) {
                    return null;
                }
                throw new XQERuntimeException(e);
            }
            return this.value;
        }

        @Override
        public void release() {
            try {
                if (this.iStream != null) {
                    this.iStream.close();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.iStream = null;
            }
            this.value = null;
            super.release();
            FileBasedPersistedResultSet.this.iterators--;
            if (FileBasedPersistedResultSet.this.iterators == 0 && FileBasedPersistedResultSet.this.releaseResultSetFlag) {
                FileBasedPersistedResultSet.this.release();
            }
        }
    }
}

