/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.util;

import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.exception.XQERuntimeException;
import com.ibm.icu.text.Collator;

public class HashKeysSet {
    IValue[] keys;
    private Collator collator = null;
    private boolean useFastHash = false;

    public HashKeysSet(int size, Collator theCollator, boolean theUseFastHash) {
        this.keys = new IValue[size];
        this.collator = theCollator;
        this.setUseFastHash(theUseFastHash);
    }

    public HashKeysSet(IValue[] theKeys, Collator theCollator, boolean theUseFastHash) {
        this.keys = theKeys;
        this.setCollator(theCollator);
        this.setUseFastHash(theUseFastHash);
    }

    public HashKeysSet copy() {
        IValue[] newKeys = new IValue[this.keys.length];
        for (int i = 0; i < this.keys.length; ++i) {
            newKeys[i] = (IValue)this.keys[i].copy();
        }
        return new HashKeysSet(newKeys, this.getCollator(), this.isUseFastHash());
    }

    public void set(IRow row, int[] keymap) {
        for (int i = 0; i < this.keys.length; ++i) {
            this.keys[i] = (IValue)row.getColumn(keymap[i]).hashKey(this.collator);
        }
    }

    public void set(IRow row) {
        for (int i = 0; i < row.getNumColumns(); ++i) {
            this.keys[i] = (IValue)row.getColumn(i).hashKey(this.collator);
        }
    }

    public IValue[] getKeys() {
        return this.keys;
    }

    public int hashCode() {
        return DataTypeComparator.hashValueArray(this.keys, this.isUseFastHash());
    }

    public int sizeOf() {
        int size = ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.OBJECTSIZE);
        for (int i = 0; i < this.keys.length; ++i) {
            size += this.keys[i].sizeOf();
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HashKeysSet)) {
            return false;
        }
        HashKeysSet h = (HashKeysSet)obj;
        if (this.keys.length != h.keys.length) {
            return false;
        }
        try {
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i].compareTo(h.keys[i]) == 0) continue;
                return false;
            }
            return true;
        }
        catch (XQERuntimeException e) {
            return false;
        }
    }

    void setCollator(Collator theCollator) {
        this.collator = theCollator;
    }

    Collator getCollator() {
        return this.collator;
    }

    void setUseFastHash(boolean theUseFastHash) {
        this.useFastHash = theUseFastHash;
    }

    boolean isUseFastHash() {
        return this.useFastHash;
    }
}

