/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.util.xml.XMLWriter;
import com.ibm.icu.text.Collator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class ColumnVector {
    protected IDataType dataType;
    protected FormatId formatId;
    public boolean isRepeating;
    public boolean[] isNull;
    public boolean noNulls;
    public boolean isSorted;

    public ColumnVector(IDataType dType, boolean valuesAreSorted, int vectorSize) {
        this.dataType = dType;
        this.formatId = FormatId.INVALID_FORMAT_FID;
        this.isNull = new boolean[vectorSize];
        this.noNulls = true;
        this.isSorted = valuesAreSorted;
    }

    public void reset() {
        if (!this.noNulls) {
            Arrays.fill(this.isNull, false);
        }
        this.noNulls = true;
        this.isRepeating = false;
    }

    public IDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(IDataType theDataType) {
        this.dataType = theDataType;
    }

    public FormatId getFormatId() {
        return this.formatId;
    }

    public void setFormatID(FormatId theFormatId) {
        this.formatId = theFormatId;
    }

    public void setFormatID(String keyword, FormatId ... operandIds) {
        ArrayList<FormatId> ids = new ArrayList<FormatId>();
        for (FormatId operandId : operandIds) {
            ids.add(operandId);
        }
        this.formatId = FormatService.getInstance().formatResult(keyword, ids);
    }

    public abstract Object getObject(int var1);

    public abstract byte[] getBytes(int var1);

    public long getLong(int index) {
        throw new UnsupportedOperationException();
    }

    public Long getLongImplicitCast(int index) {
        return this.getLong(index);
    }

    public float getFloat(int index) throws ValueConversionException {
        throw new UnsupportedOperationException();
    }

    public double getDouble(int index) {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(int index) {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(int index, int precision, int scale) {
        throw new UnsupportedOperationException();
    }

    public String getString(int index) {
        throw new UnsupportedOperationException();
    }

    public void setNull(int dstIndex) {
        this.isNull[dstIndex] = true;
        this.noNulls = false;
    }

    public abstract void copyFrom(int var1, ColumnVector var2, int var3);

    public abstract void assign(int var1, ColumnVector var2, int var3);

    public void assign(int index, IValue value) {
        if (value.isNull()) {
            this.isNull[index] = true;
            this.noNulls = false;
        } else if (null == ((Value)value).getObject()) {
            this.assign(index, null);
            this.isNull[index] = true;
            this.noNulls = false;
        } else {
            this.assign(index, ((Value)value).getObject());
            this.isNull[index] = false;
        }
    }

    public abstract void assign(int var1, Object var2);

    public void vectorCopy(ColumnVector srcVector, int size) {
        this.noNulls = srcVector.noNulls;
        this.isRepeating = srcVector.isRepeating;
        System.arraycopy(srcVector.isNull, 0, this.isNull, 0, size);
        this.vectorCopyImpl(srcVector, size);
    }

    public abstract void vectorCopyImpl(ColumnVector var1, int var2);

    public abstract void complete(int var1);

    public abstract boolean equals(int var1, int var2);

    public abstract boolean equals(int var1, ColumnVector var2, int var3);

    public abstract boolean equals(int var1, Object var2);

    public abstract int compare(int var1, int var2);

    public abstract int compare(int var1, ColumnVector var2, int var3);

    public abstract int compareWithImplicitCast(int var1, ColumnVector var2, int var3);

    public abstract boolean copyValue(int var1, int var2, ColumnVector var3, boolean var4);

    protected abstract boolean materializeRepeatingValues(int var1);

    public abstract ColumnVector copy(int var1);

    public void expand(int size) {
        boolean[] newIsNull = new boolean[this.isNull.length + size];
        System.arraycopy(this.isNull, 0, newIsNull, 0, this.isNull.length);
        this.isNull = newIsNull;
        this.expandImpl(size);
    }

    public abstract void expandImpl(int var1);

    public void encode(XDataContext context, DataOutput oStream, int size, int[] selected) throws IOException {
        block6: {
            oStream.writeInt(size);
            oStream.writeBoolean(this.isRepeating);
            oStream.writeBoolean(this.isSorted);
            oStream.writeBoolean(this.noNulls);
            if (this.noNulls) break block6;
            if (this.isRepeating) {
                oStream.writeBoolean(this.isNull[0]);
            } else if (selected != null) {
                for (int i = 0; i < size; ++i) {
                    oStream.writeBoolean(this.isNull[selected[i]]);
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    oStream.writeBoolean(this.isNull[i]);
                }
            }
        }
    }

    public int decode(XDataContext context, DataInput iStream) throws IOException {
        int size = iStream.readInt();
        this.isRepeating = iStream.readBoolean();
        this.isSorted = iStream.readBoolean();
        this.noNulls = iStream.readBoolean();
        if (!this.noNulls) {
            if (this.isRepeating) {
                this.isNull[0] = iStream.readBoolean();
            } else {
                for (int i = 0; i < size; ++i) {
                    this.isNull[i] = iStream.readBoolean();
                }
            }
        }
        return size;
    }

    public int sizeOf() {
        int result = 0;
        result += ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.PRIMITIVEBOOLEAN) * this.isNull.length;
        result += ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.PRIMITIVEBOOLEAN);
        result += ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.PRIMITIVEBOOLEAN);
        return result += ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.PRIMITIVEBOOLEAN);
    }

    public abstract int hashCode(int var1);

    public int fastHash(int index) {
        return this.hashCode(index);
    }

    public void valueToXMLString(XMLWriter writer, int index) {
        if (this.isNull[index]) {
            writer.attribute("state", "null");
        } else {
            this.valueToXMLStringImpl(writer, index);
        }
    }

    public abstract void getValue(int var1, Value var2);

    public abstract void valueToXMLStringImpl(XMLWriter var1, int var2);

    public void setCollator(Collator collator) {
    }

    public Collator getCollator() {
        return null;
    }

    public boolean isNormalized() {
        return false;
    }

    public boolean isSorted() {
        return this.isSorted;
    }

    public static byte[] longToByteArray(long data) {
        return new byte[]{(byte)(data >> 56 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 0 & 0xFFL)};
    }

    public static int compareWithImplicitCast(ColumnVector vector1, int i1, ColumnVector vector2, int i2) {
        IDataType dt2;
        IDataType dt1 = vector1.getDataType();
        if (DataTypeComparator.areCompatibleDataTypes(dt1, dt2 = vector2.getDataType())) {
            return vector1.compareWithImplicitCast(i1, vector2, i2);
        }
        if (vector2 instanceof LongColumnVector) {
            return vector2.compareWithImplicitCast(i2, vector1, i1);
        }
        return vector1.compareWithImplicitCast(i1, vector2, i2);
    }
}

