/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.data.types.CharType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.NCharType;
import com.cognos.xqe.data.types.NVarcharType;
import com.cognos.xqe.data.types.VarcharType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.DecimalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.DoubleColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.util.xml.XMLWriter;
import com.ibm.icu.text.Collator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class StringColumnVector
extends ColumnVector {
    private int maximumLength = -1;
    private static final int UGLY_MULTIPLIER = 2;
    private static final int UGLY_ADDITIVE = 2;
    protected static final String SPACE = " ";
    protected static final int NULLVALUE_HASHCODE = Integer.MIN_VALUE;
    public String[] vector;
    protected Collator collator;
    protected int[] hashCodes;

    public StringColumnVector(IDataType dType, boolean sorted, int vectorSize, Collator c) {
        super(dType, sorted, vectorSize);
        this.vector = new String[vectorSize];
        this.noNulls = true;
        this.collator = c;
        this.hashCodes = new int[vectorSize];
        Arrays.fill(this.hashCodes, Integer.MIN_VALUE);
    }

    @Override
    public void reset() {
        super.reset();
        Arrays.fill(this.hashCodes, Integer.MIN_VALUE);
    }

    @Override
    public void copyFrom(int dstIndex, ColumnVector srcVector, int inSrcIndex) {
        int srcIndex = inSrcIndex;
        if (srcVector.isRepeating) {
            srcIndex = 0;
        }
        if (srcVector.isNull[srcIndex]) {
            this.isNull[dstIndex] = true;
            this.noNulls = false;
        }
        this.vector[dstIndex] = srcVector.getString(srcIndex);
        if (this.vector[dstIndex] == null) {
            this.isNull[dstIndex] = true;
            this.noNulls = false;
        } else {
            this.isNull[dstIndex] = false;
        }
    }

    @Override
    public void assign(int dstIndex, ColumnVector srcVector, int inSrcIndex) {
        int srcIndex = inSrcIndex;
        if (srcVector.isRepeating) {
            srcIndex = 0;
        }
        this.vector[dstIndex] = StringColumnVector.getString(srcVector, srcIndex);
        if (this.vector[dstIndex] == null) {
            this.isNull[dstIndex] = true;
            this.noNulls = false;
        } else if (srcVector.isNull[srcIndex]) {
            this.isNull[dstIndex] = true;
            this.noNulls = false;
        } else {
            this.isNull[dstIndex] = false;
        }
    }

    @Override
    public void assign(int index, IValue value) {
        if (value.isNull()) {
            this.isNull[index] = true;
            this.noNulls = false;
            this.vector[index] = null;
        } else {
            this.vector[index] = ((Value)value).getString();
            if (this.vector[index] == null) {
                this.isNull[index] = true;
                this.noNulls = false;
            } else {
                this.isNull[index] = false;
            }
        }
    }

    @Override
    public void assign(int index, Object value) {
        if (value == null) {
            this.vector[index] = null;
            this.isNull[index] = true;
            this.noNulls = false;
        } else {
            this.vector[index] = value.toString();
            if (this.vector[index] == null) {
                this.isNull[index] = true;
                this.noNulls = false;
            } else {
                this.isNull[index] = false;
            }
        }
    }

    @Override
    public void vectorCopyImpl(ColumnVector srcVector, int size) {
        String[] inputVector = ((StringColumnVector)srcVector).vector;
        if (this.isRepeating) {
            this.vector[0] = inputVector[0];
        } else {
            System.arraycopy(inputVector, 0, this.vector, 0, size);
        }
    }

    @Override
    public void complete(int nValues) {
        if (!this.isSorted) {
            return;
        }
        if (this.isNull[0] || this.isNull[nValues - 1]) {
            this.noNulls = false;
            this.isRepeating = this.isNull[0] && this.isNull[nValues - 1];
        } else {
            this.isRepeating = this.vector[0].equals(this.vector[nValues - 1]);
        }
    }

    @Override
    public Object getObject(int index) {
        return this.vector[index];
    }

    @Override
    public byte[] getBytes(int index) {
        return this.vector[index].getBytes();
    }

    @Override
    public String getString(int index) {
        return this.vector[index];
    }

    @Override
    public Long getLongImplicitCast(int index) {
        try {
            return Long.valueOf(this.getString(index));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public void append(int index, String leftValue, String rightValue) {
        int newLength;
        if (this.maximumLength != -1 && (newLength = leftValue.length() + rightValue.length()) > this.maximumLength) {
            throw new ValueConversionException(XQEMessageKeys.DAT_StringOverflowError, Integer.toString(newLength), this.dataType.getTypeName(), Integer.toString(this.maximumLength));
        }
        this.vector[index] = leftValue.concat(rightValue);
    }

    public void set(int index, String value) {
        if (value == null) {
            this.isNull[index] = true;
            return;
        }
        int maxLength = this.getMaximumLength();
        if (maxLength > 0 && value.length() > maxLength) {
            int i;
            for (i = value.length(); i > maxLength && value.charAt(i - 1) == ' '; --i) {
            }
            if (i > maxLength) {
                throw new ValueConversionException(XQEMessageKeys.DAT_StringOverflowError, Integer.toString(value.length()), this.dataType.getTypeName(), Integer.toString(maxLength));
            }
            this.vector[index] = value.substring(0, maxLength);
            this.isNull[index] = false;
        } else {
            this.vector[index] = value;
            this.isNull[index] = false;
        }
    }

    public void fill(String value) {
        this.noNulls = true;
        this.isRepeating = true;
        this.vector[0] = value;
    }

    public void copySelected(boolean selectedInUse, int[] selected, int size, StringColumnVector output) {
        int i;
        int j;
        output.noNulls = this.noNulls;
        output.isRepeating = false;
        if (this.isRepeating) {
            output.vector[0] = this.vector[0];
            output.isNull[0] = this.isNull[0];
            output.isRepeating = true;
            return;
        }
        if (selectedInUse) {
            for (j = 0; j < size; ++j) {
                i = selected[j];
                output.vector[i] = this.vector[i];
            }
        } else {
            System.arraycopy(this.vector, 0, output.vector, 0, size);
        }
        if (!this.noNulls) {
            if (selectedInUse) {
                for (j = 0; j < size; ++j) {
                    i = selected[j];
                    output.isNull[i] = this.isNull[i];
                }
            } else {
                System.arraycopy(this.isNull, 0, output.isNull, 0, size);
            }
        }
    }

    private int getMaximumLength() {
        int result = this.dataType.getPrecision();
        if (result > 0) {
            result = result * 2 + 2;
        }
        return result;
    }

    @Override
    public boolean equals(int i1, int i2) {
        return this.compare(i1, i2) == 0;
    }

    @Override
    public boolean equals(int i1, ColumnVector v2, int i2) {
        return this.compare(i1, v2, i2) == 0;
    }

    @Override
    public boolean equals(int index, Object value) {
        return this.compare(this.vector[index], (String)value, this.getDataType(), this.getDataType()) == 0;
    }

    @Override
    public int compare(int i1, int i2) {
        if (this.isRepeating) {
            return 0;
        }
        if (this.isNull[i1] && this.isNull[i2]) {
            return 0;
        }
        if (this.isNull[i1]) {
            return -1;
        }
        if (this.isNull[i2]) {
            return 1;
        }
        return this.compare(this.vector[i1], this.vector[i2], this.getDataType(), this.getDataType());
    }

    @Override
    public int compare(int i1, ColumnVector v2, int i2) {
        StringColumnVector otherVector = (StringColumnVector)v2;
        int index1 = i1;
        int index2 = i2;
        if (this.isRepeating) {
            index1 = 0;
        }
        if (v2.isRepeating) {
            index2 = 0;
        }
        if (this.isNull[index1] && otherVector.isNull[index2]) {
            return 0;
        }
        if (this.isNull[index1]) {
            return -1;
        }
        if (otherVector.isNull[index2]) {
            return 1;
        }
        return this.compare(this.vector[index1], otherVector.vector[index2], this.getDataType(), otherVector.getDataType());
    }

    private int compare(String value1, String value2, IDataType thisDT, IDataType otherDT) {
        if ((thisDT instanceof CharType || thisDT instanceof VarcharType || thisDT instanceof NCharType || thisDT instanceof NVarcharType) && (otherDT instanceof CharType || otherDT instanceof VarcharType || otherDT instanceof NCharType || otherDT instanceof NVarcharType)) {
            int thisLength;
            int pLength = value1.length();
            if (pLength < (thisLength = value2.length())) {
                value1 = StringColumnVector.padWhitespace(value1, thisLength);
            } else if (pLength > thisLength) {
                value2 = StringColumnVector.padWhitespace(value2, pLength);
            }
        }
        if (this.collator == null) {
            return value1.compareTo(value2);
        }
        int result = this.collator.compare(value1, value2);
        if (result == 0) {
            return 0;
        }
        if (result > 0) {
            return 1;
        }
        return -1;
    }

    @Override
    public int compareWithImplicitCast(int i1, ColumnVector v2, int i2) {
        return this.compare(i1, v2, i2);
    }

    @Override
    public boolean copyValue(int sIndex, int tIndex, ColumnVector targetVector, boolean addValue) {
        if (!(targetVector instanceof StringColumnVector)) {
            return false;
        }
        int sourceIndex = sIndex;
        int targetIndex = tIndex;
        StringColumnVector target = (StringColumnVector)targetVector;
        if (this.isRepeating) {
            sourceIndex = 0;
        }
        if (targetVector.isRepeating) {
            if (!this.isNull[sourceIndex] && !target.isNull[0] && this.vector[sourceIndex].equals(target.vector[0])) {
                return true;
            }
            if (this.isNull[sourceIndex] && target.isNull[0]) {
                return true;
            }
            if (targetIndex > 0) {
                if (addValue) {
                    targetVector.materializeRepeatingValues(targetIndex - 1);
                } else {
                    targetVector.materializeRepeatingValues(target.vector.length - 1);
                }
            }
        }
        targetVector.isRepeating = false;
        target.vector[targetIndex] = this.vector[sourceIndex];
        target.isNull[targetIndex] = this.isNull[sourceIndex];
        if (target.isNull[targetIndex]) {
            target.noNulls = false;
        }
        return true;
    }

    @Override
    protected boolean materializeRepeatingValues(int size) {
        if (this.isRepeating) {
            for (int i = 1; i <= size; ++i) {
                this.vector[i] = this.vector[0];
                this.isNull[i] = this.isNull[0];
            }
            return true;
        }
        return false;
    }

    @Override
    public ColumnVector copy(int size) {
        StringColumnVector copy = this.newInstance();
        copy.isRepeating = this.isRepeating;
        copy.noNulls = this.noNulls;
        if (this.isRepeating) {
            copy.vector[0] = this.vector[0];
            copy.isNull[0] = this.isNull[0];
            copy.hashCodes[0] = this.hashCodes[0];
        } else {
            for (int i = 0; i < this.vector.length; ++i) {
                copy.vector[i] = this.vector[i];
                copy.isNull[i] = this.isNull[i];
                copy.hashCodes[i] = this.hashCodes[i];
            }
        }
        return copy;
    }

    protected StringColumnVector newInstance() {
        return new StringColumnVector(this.dataType, this.isSorted, this.vector.length, this.collator);
    }

    @Override
    public void expandImpl(int size) {
        String[] newVector = new String[this.vector.length + size];
        System.arraycopy(this.vector, 0, newVector, 0, this.vector.length);
        this.vector = newVector;
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream, int size, int[] selected) throws IOException {
        block8: {
            block7: {
                super.encode(context, oStream, size, selected);
                if (!this.isRepeating) break block7;
                if (this.isNull[0]) break block8;
                oStream.writeUTF(this.vector[0]);
                break block8;
            }
            if (selected != null) {
                if (this.noNulls) {
                    for (int i = 0; i < size; ++i) {
                        oStream.writeUTF(this.vector[selected[i]]);
                    }
                } else {
                    for (int i = 0; i < size; ++i) {
                        if (this.isNull[selected[i]]) continue;
                        oStream.writeUTF(this.vector[selected[i]]);
                    }
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    if (this.isNull[i]) continue;
                    oStream.writeUTF(this.vector[i]);
                }
            }
        }
    }

    @Override
    public int decode(XDataContext context, DataInput iStream) throws IOException {
        int size;
        block5: {
            block4: {
                size = super.decode(context, iStream);
                if (!this.isRepeating) break block4;
                if (this.isNull[0]) break block5;
                this.vector[0] = iStream.readUTF();
                break block5;
            }
            if (this.noNulls) {
                for (int i = 0; i < size; ++i) {
                    this.vector[i] = iStream.readUTF();
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    if (this.isNull[i]) continue;
                    this.vector[i] = iStream.readUTF();
                }
            }
        }
        return size;
    }

    @Override
    public int sizeOf() {
        int size = super.sizeOf();
        for (int i = 0; i < this.vector.length; ++i) {
            if (this.isNull[i] || this.vector[i] == null) continue;
            size += ValueSizeInfo.getSizeOfTextValue(this.vector[i]);
        }
        return size += ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.PRIMITIVEINT) * this.vector.length;
    }

    @Override
    public int hashCode(int i) {
        int index = i;
        if (this.isRepeating) {
            index = 0;
        }
        if (this.hashCodes[index] == Integer.MIN_VALUE && !this.isNull[index]) {
            this.hashCodes[index] = this.collator != null ? (this.vector[index].isEmpty() ? 0 : (!Character.isWhitespace(this.vector[index].charAt(this.vector[index].length() - 1)) ? this.collator.getCollationKey(this.vector[index]).hashCode() : this.collator.getCollationKey(StringColumnVector.trimRightWhitespace(this.vector[index])).hashCode())) : this.vector[index].hashCode();
        }
        return this.hashCodes[index];
    }

    @Override
    public void setCollator(Collator c) {
        this.collator = c;
    }

    @Override
    public Collator getCollator() {
        return this.collator;
    }

    private static String trimRightWhitespace(String value) {
        int i;
        for (i = value.length() - 1; i >= 0 && Character.isWhitespace(value.charAt(i)); --i) {
        }
        if (i >= 0) {
            return value.substring(0, i + 1);
        }
        return "";
    }

    protected static String padWhitespace(String value, int length) {
        StringBuilder b = new StringBuilder(length);
        b.append(value);
        int padChars = length - value.length();
        for (int k = 0; k < padChars; ++k) {
            b.append(SPACE);
        }
        return b.toString();
    }

    @Override
    public void getValue(int index, Value value) {
        value.setFormatId(this.formatId);
        if (this.isNull[index]) {
            value.setNull();
        } else {
            value.set(this.vector[index]);
        }
    }

    @Override
    public void valueToXMLStringImpl(XMLWriter writer, int i) {
    }

    @Override
    public boolean isNormalized() {
        return false;
    }

    private static String getString(ColumnVector srcVector, int srcIndex) {
        if (srcVector instanceof LongColumnVector) {
            Long aLong = new Long(((LongColumnVector)srcVector).vector[srcIndex]);
            return aLong.toString();
        }
        if (srcVector instanceof DoubleColumnVector) {
            Double aDouble = new Double(((DoubleColumnVector)srcVector).vector[srcIndex]);
            return aDouble.toString();
        }
        if (srcVector instanceof DecimalColumnVector) {
            return ((DecimalColumnVector)srcVector).vector[srcIndex].toString();
        }
        return ((StringColumnVector)srcVector).vector[srcIndex];
    }
}

