/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.IEncodable;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.TimeWithTZValue;
import com.cognos.xqe.data.values.TimestampWithTZValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.IDateColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.TimestampUtil;
import com.cognos.xqe.util.xml.XMLWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class TimestampColumnVector
extends ColumnVector
implements IDateColumnVector {
    public static final long NULL_VALUE = 1L;
    private static final int PRIME = 31;
    public UnixTimestamp[] vector;
    private TimestampUtil tsUtil = new TimestampUtil();

    public TimestampColumnVector(IDataType dType, boolean isSorted, int vectorSize) {
        super(dType, isSorted, vectorSize);
        this.vector = new UnixTimestamp[vectorSize];
        for (int i = 0; i < vectorSize; ++i) {
            this.vector[i] = new UnixTimestamp(dType.getCCLTypeCode());
        }
        this.noNulls = true;
    }

    @Override
    public void complete(int nValues) {
        if (!this.isSorted) {
            return;
        }
        this.isRepeating = this.isNull[0] || this.isNull[nValues - 1] ? this.isNull[0] && this.isNull[nValues - 1] : this.vector[0].compareTo(this.vector[nValues - 1]) == 0;
    }

    @Override
    public void copyFrom(int dstIndex, ColumnVector srcVector, int inSrcIndex) {
        int srcIndex = inSrcIndex;
        if (srcVector.isRepeating) {
            srcIndex = 0;
        }
        if (srcVector.isNull[srcIndex]) {
            this.isNull[dstIndex] = true;
            this.noNulls = false;
        }
        UnixTimestamp unixTimestamp = ((TimestampColumnVector)srcVector).vector[srcIndex];
        this.vector[dstIndex].milliseconds = unixTimestamp.milliseconds;
        this.vector[dstIndex].nanoseconds = unixTimestamp.nanoseconds;
        this.vector[dstIndex].timeZoneOffset = unixTimestamp.timeZoneOffset;
    }

    @Override
    public void assign(int index, IValue value) {
        if (value.isNull()) {
            this.isNull[index] = true;
            this.noNulls = false;
            return;
        }
        if (value instanceof DateTimeValue) {
            UnixTimestamp unixTimestamp = this.vector[index];
            unixTimestamp.milliseconds = ((DateTimeValue)value).getMilliseconds();
            unixTimestamp.nanoseconds = ((DateTimeValue)value).getNanoseconds();
            if (value instanceof TimeWithTZValue || value instanceof TimestampWithTZValue) {
                unixTimestamp.timeZoneOffset = ((DateTimeValue)value).getTimeZone().getRawOffset();
            }
        } else {
            this.assign(index, ((Value)value).getObject());
        }
    }

    @Override
    public void assign(int index, Object value) {
        if (value == null) {
            this.isNull[index] = true;
            this.noNulls = false;
            return;
        }
        UnixTimestamp uxTimestamp = this.vector[index];
        if (value instanceof String) {
            switch (this.dataType.getCCLTypeCode()) {
                case 58: {
                    this.tsUtil.parseTime((String)value, uxTimestamp);
                    break;
                }
                case 59: {
                    this.tsUtil.parseTimestamp((String)value, uxTimestamp);
                    break;
                }
                case 52: {
                    this.tsUtil.parseTimeWithTZ((String)value, uxTimestamp);
                    break;
                }
                case 53: {
                    this.tsUtil.parseTimestampWithTZ((String)value, uxTimestamp);
                    break;
                }
            }
        } else if (value instanceof UnixTimestamp) {
            uxTimestamp.milliseconds = ((UnixTimestamp)value).milliseconds;
            uxTimestamp.nanoseconds = ((UnixTimestamp)value).nanoseconds;
            uxTimestamp.timeZoneOffset = ((UnixTimestamp)value).timeZoneOffset;
        } else if (value instanceof Date) {
            uxTimestamp.milliseconds = ((Date)value).getTime();
            uxTimestamp.nanoseconds = 0;
        } else if (value instanceof Time) {
            long ms = ((Time)value).getTime();
            long milliseconds = ms / 1000L * 1000L;
            int nanoseconds = (int)(ms % 1000L * 1000000L);
            if (nanoseconds < 0) {
                nanoseconds = 1000000000 + nanoseconds;
                milliseconds = (milliseconds / 1000L - 1L) * 1000L;
            }
            uxTimestamp.milliseconds = milliseconds;
            uxTimestamp.nanoseconds = nanoseconds;
        } else if (value instanceof Timestamp) {
            uxTimestamp.milliseconds = ((Timestamp)value).getTime();
            uxTimestamp.nanoseconds = ((Timestamp)value).getNanos();
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void assign(int dstIndex, ColumnVector srcVector, int inSrcIndex) {
        int srcIndex = inSrcIndex;
        if (srcVector.isRepeating) {
            srcIndex = 0;
        }
        if (((TimestampColumnVector)srcVector).isNull[srcIndex]) {
            this.isNull[dstIndex] = true;
            this.noNulls = false;
        }
        this.set(dstIndex, ((TimestampColumnVector)srcVector).vector[srcIndex]);
    }

    @Override
    public void vectorCopyImpl(ColumnVector srcVector, int size) {
        UnixTimestamp[] inputVector = ((TimestampColumnVector)srcVector).vector;
        if (this.isRepeating) {
            this.vector[0] = inputVector[0];
        } else {
            System.arraycopy(inputVector, 0, this.vector, 0, size);
        }
    }

    public void set(int index, UnixTimestamp value) {
        if (value == null) {
            this.isNull[index] = true;
            return;
        }
        if (this.vector[index] == null) {
            this.vector[index] = value.copy();
            return;
        }
        this.vector[index].milliseconds = value.milliseconds;
        this.vector[index].nanoseconds = value.nanoseconds;
        this.vector[index].timeZoneOffset = value.timeZoneOffset;
    }

    @Override
    public Object getObject(int index) {
        UnixTimestamp uxTimestamp = this.vector[index];
        switch (this.dataType.getCCLTypeCode()) {
            case 57: {
                return new Date(uxTimestamp.milliseconds);
            }
            case 52: 
            case 58: {
                return new Time(uxTimestamp.milliseconds);
            }
            case 53: 
            case 59: {
                Timestamp ts = new Timestamp(0L);
                ts.setTime(uxTimestamp.milliseconds);
                ts.setNanos(uxTimestamp.nanoseconds);
            }
        }
        throw new XQERuntimeException(new IllegalArgumentException());
    }

    @Override
    public byte[] getBytes(int index) {
        throw new UnsupportedOperationException();
    }

    public void fill(UnixTimestamp value) {
        this.noNulls = true;
        this.isRepeating = true;
        this.vector[0] = value;
    }

    @Override
    public boolean equals(int index1, int index2) {
        if (this.isRepeating) {
            return true;
        }
        if (this.isNull[index1] && this.isNull[index2]) {
            return true;
        }
        if (this.isNull[index1] || this.isNull[index2]) {
            return false;
        }
        return this.vector[index1].equals(this.vector[index2]);
    }

    @Override
    public boolean equals(int i1, ColumnVector v2, int i2) {
        TimestampColumnVector otherVector = (TimestampColumnVector)v2;
        int index1 = i1;
        int index2 = i2;
        if (this.isRepeating) {
            index1 = 0;
        }
        if (v2.isRepeating) {
            index2 = 0;
        }
        if (this.isNull[index1] && otherVector.isNull[index2]) {
            return true;
        }
        if (this.isNull[index1] || otherVector.isNull[index2]) {
            return false;
        }
        return this.vector[index1].equals(otherVector.vector[index2]);
    }

    @Override
    public boolean equals(int i, Object value) {
        return false;
    }

    @Override
    public int compare(int index1, int index2) {
        if (this.isRepeating) {
            return 0;
        }
        if (this.isNull[index1] && this.isNull[index2]) {
            return 0;
        }
        if (this.isNull[index1]) {
            return -1;
        }
        if (this.isNull[index2]) {
            return 1;
        }
        return this.vector[index1].compareTo(this.vector[index2]);
    }

    @Override
    public int compare(int i1, ColumnVector v2, int i2) {
        TimestampColumnVector otherVector = (TimestampColumnVector)v2;
        int index1 = i1;
        int index2 = i2;
        if (this.isRepeating) {
            index1 = 0;
        }
        if (v2.isRepeating) {
            index2 = 0;
        }
        if (this.isNull[index1] && otherVector.isNull[index2]) {
            return 0;
        }
        if (this.isNull[index1]) {
            return -1;
        }
        if (otherVector.isNull[index2]) {
            return 1;
        }
        return this.vector[index1].compareTo(otherVector.vector[index2]);
    }

    @Override
    public int compareWithImplicitCast(int i1, ColumnVector v2, int i2) {
        return this.compare(i1, v2, i2);
    }

    @Override
    public boolean copyValue(int sIndex, int tIndex, ColumnVector targetVector, boolean addValue) {
        int sourceIndex = sIndex;
        int targetIndex = tIndex;
        TimestampColumnVector target = (TimestampColumnVector)targetVector;
        if (this.isRepeating) {
            sourceIndex = 0;
        }
        if (targetVector.isRepeating) {
            if (!this.isNull[sourceIndex] && !target.isNull[0] && this.vector[sourceIndex].compareTo(target.vector[0]) == 0) {
                return true;
            }
            if (this.isNull[sourceIndex] && target.isNull[0]) {
                return true;
            }
            if (targetIndex > 0) {
                if (addValue) {
                    targetVector.materializeRepeatingValues(targetIndex - 1);
                } else {
                    targetVector.materializeRepeatingValues(target.vector.length - 1);
                }
            }
        }
        targetVector.isRepeating = false;
        target.set(targetIndex, this.vector[sourceIndex]);
        target.isNull[targetIndex] = this.isNull[sourceIndex];
        if (target.isNull[targetIndex]) {
            target.noNulls = false;
        }
        return true;
    }

    public void copySelected(boolean selectedInUse, int[] selected, int size, TimestampColumnVector output) {
        int i;
        int j;
        output.noNulls = this.noNulls;
        output.isRepeating = false;
        if (this.isRepeating) {
            output.vector[0] = this.vector[0];
            output.isNull[0] = this.isNull[0];
            output.isRepeating = true;
            return;
        }
        if (selectedInUse) {
            for (j = 0; j < size; ++j) {
                i = selected[j];
                output.vector[i] = this.vector[i];
            }
        } else {
            System.arraycopy(this.vector, 0, output.vector, 0, size);
        }
        if (!this.noNulls) {
            if (selectedInUse) {
                for (j = 0; j < size; ++j) {
                    i = selected[j];
                    output.isNull[i] = this.isNull[i];
                }
            } else {
                System.arraycopy(this.isNull, 0, output.isNull, 0, size);
            }
        }
    }

    @Override
    protected boolean materializeRepeatingValues(int size) {
        if (this.isRepeating) {
            for (int i = 1; i <= size; ++i) {
                this.set(i, this.vector[0]);
                this.isNull[i] = this.isNull[0];
            }
            return true;
        }
        return false;
    }

    @Override
    public ColumnVector copy(int size) {
        TimestampColumnVector copy = new TimestampColumnVector(this.dataType, this.isSorted, this.vector.length);
        copy.isRepeating = this.isRepeating;
        copy.noNulls = this.noNulls;
        if (this.isRepeating) {
            copy.set(0, this.vector[0]);
            copy.isNull[0] = this.isNull[0];
        } else {
            for (int i = 0; i < this.vector.length; ++i) {
                copy.set(i, this.vector[i]);
                copy.isNull[i] = this.isNull[i];
            }
        }
        return copy;
    }

    @Override
    public void expandImpl(int size) {
        UnixTimestamp[] newVector = new UnixTimestamp[this.vector.length + size];
        for (int i = 0; i < newVector.length; ++i) {
            newVector[i] = new UnixTimestamp(this.dataType.getCCLTypeCode());
        }
        System.arraycopy(this.vector, 0, newVector, 0, this.vector.length);
        this.vector = newVector;
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream, int size, int[] selected) throws IOException {
        block11: {
            block10: {
                super.encode(context, oStream, size, selected);
                if (!this.isRepeating) break block10;
                if (this.isNull[0]) break block11;
                this.vector[0].encode(context, oStream);
                break block11;
            }
            if (selected != null) {
                if (this.noNulls) {
                    for (int i = 0; i < size; ++i) {
                        this.vector[selected[i]].encode(context, oStream);
                    }
                } else {
                    for (int i = 0; i < size; ++i) {
                        if (this.isNull[selected[i]]) continue;
                        this.vector[selected[i]].encode(context, oStream);
                    }
                }
            } else if (this.noNulls) {
                for (int i = 0; i < size; ++i) {
                    this.vector[i].encode(context, oStream);
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    if (this.isNull[i]) continue;
                    this.vector[i].encode(context, oStream);
                }
            }
        }
    }

    @Override
    public int decode(XDataContext context, DataInput iStream) throws IOException {
        int size;
        block5: {
            block4: {
                size = super.decode(context, iStream);
                if (!this.isRepeating) break block4;
                if (this.isNull[0]) break block5;
                this.vector[0].decode(context, iStream);
                break block5;
            }
            if (this.noNulls) {
                for (int i = 0; i < size; ++i) {
                    this.vector[i].decode(context, iStream);
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    if (this.isNull[i]) continue;
                    this.vector[i].decode(context, iStream);
                }
            }
        }
        return size;
    }

    @Override
    public int sizeOf() {
        int result = super.sizeOf();
        result += ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.PRIMITIVELONG) * this.vector.length;
        return result += ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.PRIMITIVEINT) * this.vector.length;
    }

    @Override
    public int hashCode(int i) {
        int index = i;
        if (this.isRepeating) {
            index = 0;
        }
        if (this.isNull[index]) {
            return Integer.MIN_VALUE;
        }
        return 31 * Long.hashCode(this.vector[index].milliseconds) + this.vector[index].nanoseconds;
    }

    @Override
    public long getMilliseconds(int index) {
        return this.vector[index].milliseconds;
    }

    @Override
    public int getNanoseconds(int index) {
        return this.vector[index].nanoseconds;
    }

    @Override
    public void getValue(int index, Value value) {
        value.setFormatId(this.formatId);
        if (this.isNull[index]) {
            value.setNull();
        } else {
            ((DateTimeValue)value).set(this.vector[index].milliseconds);
            ((DateTimeValue)value).setNanoseconds(this.vector[index].nanoseconds);
            if (value instanceof TimeWithTZValue || value instanceof TimestampWithTZValue) {
                ((DateTimeValue)value).setTimeZone(this.vector[index].timeZoneOffset);
            }
        }
    }

    @Override
    public void valueToXMLStringImpl(XMLWriter writer, int i) {
    }

    public static class UnixTimestamp
    implements Comparable<UnixTimestamp>,
    IEncodable {
        public long milliseconds;
        public int nanoseconds;
        public int timeZoneOffset;
        public byte cclDType;

        public UnixTimestamp(byte dType) {
            this.cclDType = dType;
        }

        public UnixTimestamp(byte dType, long millis, int nanos) {
            this.cclDType = dType;
            this.milliseconds = millis;
            this.nanoseconds = nanos;
        }

        public UnixTimestamp(byte dType, long millis, int nanos, int tzOffset) {
            this.cclDType = dType;
            this.milliseconds = millis;
            this.nanoseconds = nanos;
            this.timeZoneOffset = tzOffset;
        }

        public UnixTimestamp copy() {
            return new UnixTimestamp(this.cclDType, this.milliseconds, this.nanoseconds, this.timeZoneOffset);
        }

        public void copyFrom(UnixTimestamp ts) {
            this.milliseconds = ts.milliseconds;
            this.nanoseconds = ts.nanoseconds;
            this.timeZoneOffset = ts.timeZoneOffset;
        }

        public void set(long millis, int nanos) {
            this.milliseconds = millis;
            this.nanoseconds = nanos;
        }

        public void set(long millis, int nanos, int tzOffset) {
            this.milliseconds = millis;
            this.nanoseconds = nanos;
            this.timeZoneOffset = tzOffset;
        }

        public void setTimeZoneOffset(int tzOffset) {
            this.timeZoneOffset = tzOffset;
        }

        public boolean isTimeType() {
            return DataTypeCode.isTime(this.cclDType);
        }

        public boolean equals(UnixTimestamp uxTimestamp) {
            return this.milliseconds == uxTimestamp.milliseconds && this.nanoseconds == uxTimestamp.nanoseconds;
        }

        @Override
        public int compareTo(UnixTimestamp uxTimestamp) {
            if (this.milliseconds > uxTimestamp.milliseconds) {
                return 1;
            }
            if (this.milliseconds < uxTimestamp.milliseconds) {
                return -1;
            }
            if (this.nanoseconds == uxTimestamp.nanoseconds) {
                return 0;
            }
            if (this.nanoseconds > uxTimestamp.nanoseconds) {
                return 1;
            }
            return -1;
        }

        @Override
        public void encode(XDataContext context, DataOutput oStream) throws IOException {
            oStream.writeLong(this.milliseconds);
            oStream.writeInt(this.nanoseconds);
        }

        @Override
        public void decode(XDataContext context, DataInput iStream) throws IOException {
            this.milliseconds = iStream.readLong();
            this.nanoseconds = iStream.readInt();
        }

        @Override
        public int sizeOf() {
            return 0;
        }
    }
}

