/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntervalQualifier;
import com.cognos.xqe.data.types.IntervalType;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.IntervalDayTimeValue;
import com.cognos.xqe.data.values.IntervalYearMonthValue;
import com.cognos.xqe.data.values.TimeValue;
import com.cognos.xqe.data.values.TimeWithTZValue;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.data.values.TimestampWithTZValue;
import com.cognos.xqe.data.values.ValueArithmeticException;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.runtree.relational.vectorization.IntervalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.regex.Matcher;
import org.apache.axis.types.Duration;

public class TimestampUtil {
    public static final int YEAR = 0;
    public static final int MONTH = 1;
    public static final int DAY = 0;
    public static final int HOUR = 1;
    public static final int MINUTE = 2;
    public static final int SECOND = 3;
    public static final int NANOSECONDS = 4;
    private static final String PERIOD = "\\.";
    private static final String PLUS_OR_MINUS = "\\+|-";
    private static final String ASTERISK = "*";
    private static final String HYPHEN = "-";
    protected final GregorianCalendar calendar = new GregorianCalendar();
    protected final Calendar calendar2;

    public TimestampUtil() {
        this.calendar.setFirstDayOfWeek(2);
        this.calendar.setMinimalDaysInFirstWeek(4);
        this.calendar.clear();
        this.calendar2 = (Calendar)this.calendar.clone();
    }

    public void add(int i, long arg1, IntervalColumnVector.IntervalStruct arg2, LongColumnVector outputColumnVector) {
        this.calendar.clear();
        this.calendar.setTimeInMillis(arg1);
        if (arg2.isYearMonthInterval()) {
            this.calendar.add(1, arg2.sign * arg2.fields[0]);
            this.calendar.add(2, arg2.sign * arg2.fields[1]);
        } else {
            this.calendar.add(5, arg2.sign * arg2.fields[0]);
        }
        outputColumnVector.vector[i] = this.calendar.getTimeInMillis();
    }

    public void add(int i, IntervalColumnVector.IntervalStruct arg1, long arg2, LongColumnVector outputColumnVector) {
        this.add(i, arg2, arg1, outputColumnVector);
    }

    public void add(int i, TimestampColumnVector.UnixTimestamp arg1, IntervalColumnVector.IntervalStruct arg2, TimestampColumnVector outputColumnVector) {
        int nanoseconds;
        this.calendar.clear();
        this.calendar.setTimeInMillis(arg1.milliseconds);
        TimestampColumnVector.UnixTimestamp uxTimestamp = outputColumnVector.vector[i];
        if (arg2.isYearMonthInterval()) {
            this.calendar.add(1, arg2.sign * arg2.fields[0]);
            this.calendar.add(2, arg2.sign * arg2.fields[1]);
            nanoseconds = arg1.nanoseconds;
        } else {
            this.calendar.add(5, arg2.sign * arg2.fields[0]);
            this.calendar.add(11, arg2.sign * arg2.fields[1]);
            this.calendar.add(12, arg2.sign * arg2.fields[2]);
            this.calendar.add(13, arg2.sign * arg2.fields[3]);
            long nanosecs = arg1.nanoseconds + arg2.sign * arg2.fields[4];
            int seconds = (int)(nanosecs / 1000000000L);
            nanoseconds = (int)(nanosecs % 1000000000L);
            if (nanoseconds < 0) {
                --seconds;
                nanoseconds += 1000000000;
            }
            this.calendar.add(13, seconds);
        }
        uxTimestamp.milliseconds = this.calendar.getTimeInMillis();
        uxTimestamp.nanoseconds = nanoseconds;
        uxTimestamp.timeZoneOffset = arg1.timeZoneOffset;
    }

    public void add(int i, IntervalColumnVector.IntervalStruct arg1, TimestampColumnVector.UnixTimestamp arg2, TimestampColumnVector outputColumnVector) {
        this.add(i, arg2, arg1, outputColumnVector);
    }

    public void add(int i, IntervalColumnVector.IntervalStruct arg1, IntervalColumnVector.IntervalStruct arg2, IntervalColumnVector outputColumnVector) {
        IntervalColumnVector.IntervalStruct ois = outputColumnVector.vector[i];
        if (arg1.isYearMonthInterval()) {
            int months = arg1.fields[0] * 12 + arg1.fields[1];
            int offsetMonths = arg2.fields[0] * 12 + arg2.fields[1];
            int newMonths = arg1.sign * months + arg2.sign * offsetMonths;
            int absNewMonths = StrictMath.abs(newMonths);
            ois.fields[0] = absNewMonths / 12;
            ois.fields[1] = absNewMonths % 12;
            ois.sign = 1;
            if (newMonths < 0) {
                ois.sign = -1;
            }
        } else {
            int fracSecs;
            int newFracSecsSign;
            long lSeconds = (long)arg1.fields[0] * 86400L + (long)arg1.fields[1] * 3600L + (long)arg1.fields[2] * 60L + (long)arg1.fields[3];
            long rSeconds = (long)arg2.fields[0] * 86400L + (long)arg2.fields[1] * 3600L + (long)arg2.fields[2] * 60L + (long)arg2.fields[3];
            long sumInSeconds = (long)arg1.sign * lSeconds + (long)arg2.sign * rSeconds;
            int newSecsSign = sumInSeconds >= 0L ? 1 : -1;
            if (newSecsSign == (newFracSecsSign = (fracSecs = arg1.sign * arg1.fields[4] + arg2.sign * arg2.fields[4]) >= 0 ? 1 : -1) || fracSecs == 0) {
                sumInSeconds = StrictMath.abs(sumInSeconds);
                ois.fields[4] = StrictMath.abs(fracSecs);
                ois.sign = newSecsSign;
            } else if (newSecsSign > 0) {
                sumInSeconds = StrictMath.abs(sumInSeconds - 1L);
                ois.fields[4] = 1000000000 - StrictMath.abs(fracSecs);
                ois.sign = 1;
            } else {
                sumInSeconds = StrictMath.abs(sumInSeconds + 1L);
                ois.fields[4] = 1000000000 - StrictMath.abs(fracSecs);
                ois.sign = -1;
            }
            ois.fields[3] = (int)(sumInSeconds % 60L);
            sumInSeconds = StrictMath.abs(sumInSeconds) / 60L;
            ois.fields[2] = (int)(sumInSeconds % 60L);
            sumInSeconds = StrictMath.abs(sumInSeconds) / 60L;
            ois.fields[1] = (int)(sumInSeconds % 24L);
            sumInSeconds = StrictMath.abs(sumInSeconds) / 24L;
            if (sumInSeconds <= Integer.MAX_VALUE) {
                ois.fields[0] = (int)sumInSeconds;
            } else {
                throw new ValueArithmeticException(XQEMessageKeys.DAT_NumericOverflowError, arg1.toString(), "add", arg2.toString(), "integer");
            }
        }
        ois.normalize();
    }

    public void subtract(int i, long arg1, IntervalColumnVector.IntervalStruct arg2, LongColumnVector outputColumnVector) {
        this.calendar.setTimeInMillis(arg1);
        int sign = -arg2.sign;
        if (arg2.isYearMonthInterval()) {
            this.calendar.add(1, sign * arg2.fields[0]);
            this.calendar.add(2, sign * arg2.fields[1]);
        } else {
            this.calendar.add(5, sign * arg2.fields[0]);
        }
        outputColumnVector.vector[i] = this.calendar.getTimeInMillis();
    }

    public void subtract(int i, TimestampColumnVector.UnixTimestamp arg1, IntervalColumnVector.IntervalStruct arg2, TimestampColumnVector outputColumnVector) {
        this.calendar.setTimeInMillis(arg1.milliseconds);
        TimestampColumnVector.UnixTimestamp uxTimestamp = outputColumnVector.vector[i];
        int sign = -arg2.sign;
        if (arg2.isYearMonthInterval()) {
            this.calendar.add(1, sign * arg2.fields[0]);
            this.calendar.add(2, sign * arg2.fields[1]);
            uxTimestamp.nanoseconds = arg1.nanoseconds;
        } else {
            this.calendar.add(5, sign * arg2.fields[0]);
            this.calendar.add(10, sign * arg2.fields[1]);
            this.calendar.add(12, sign * arg2.fields[2]);
            this.calendar.add(13, sign * arg2.fields[3]);
            long nanoseconds = arg1.nanoseconds + sign * arg2.fields[4];
            int seconds = (int)(nanoseconds / 1000000000L);
            uxTimestamp.nanoseconds = (int)(nanoseconds % 1000000000L);
            if (uxTimestamp.nanoseconds < 0) {
                --seconds;
                uxTimestamp.nanoseconds += 1000000000;
            }
            this.calendar.add(13, seconds);
        }
        uxTimestamp.milliseconds = this.calendar.getTimeInMillis();
        uxTimestamp.timeZoneOffset = arg1.timeZoneOffset;
    }

    public void subtract(int i, long arg1, long arg2, IntervalColumnVector outputColumnVector) {
        int sign;
        boolean isNegative;
        long milliseconds = 0L;
        this.calendar.setTimeInMillis(arg1);
        this.calendar2.setTimeInMillis(arg2);
        milliseconds = DateTimeValue.subtractNoDST(this.calendar, this.calendar2);
        boolean bl = isNegative = milliseconds < 0L;
        if (isNegative) {
            sign = -1;
            milliseconds = Math.abs(milliseconds);
        } else {
            sign = 1;
        }
        int days = (int)(milliseconds / 86400000L);
        outputColumnVector.vector[i].set(sign, days, 0, 0, 0, 0);
    }

    public void subtract(int i, TimestampColumnVector.UnixTimestamp arg1, TimestampColumnVector.UnixTimestamp arg2, IntervalColumnVector outputColumnVector) {
        int sign;
        boolean isNegative;
        long milliseconds = 0L;
        this.calendar.setTimeInMillis(arg1.milliseconds);
        this.calendar2.setTimeInMillis(arg2.milliseconds);
        milliseconds = arg1.isTimeType() && arg2.isTimeType() ? IntervalDayTimeValue.getDefaultUTCTime(this.calendar) - IntervalDayTimeValue.getDefaultUTCTime(this.calendar2) : DateTimeValue.subtractNoDST(this.calendar, this.calendar2);
        boolean bl = isNegative = milliseconds < 0L;
        if (isNegative) {
            sign = -1;
            milliseconds = Math.abs(milliseconds);
        } else {
            sign = 1;
        }
        int days = (int)(milliseconds / 86400000L);
        int r1 = (int)(milliseconds / 1000L % 86400L);
        int r2 = r1 % 3600;
        int hours = r1 / 3600;
        int minutes = r2 / 60;
        int seconds = r2 % 60;
        int nanoseconds = arg1.nanoseconds - arg2.nanoseconds;
        if (nanoseconds < 0 && milliseconds == 0L) {
            isNegative = true;
            sign = -1;
        }
        if (isNegative) {
            nanoseconds = -nanoseconds;
        }
        if (nanoseconds < 0) {
            nanoseconds += 1000000000;
            --seconds;
        }
        if (seconds < 0) {
            seconds += 60;
            --minutes;
        }
        if (minutes < 0) {
            minutes += 60;
            --hours;
        }
        if (hours < 0) {
            hours += 24;
            --days;
        }
        outputColumnVector.vector[i].set(sign, days, hours, minutes, seconds, nanoseconds);
    }

    public void multiply(int i, IntervalColumnVector.IntervalStruct arg1, double arg2, IntervalColumnVector outputColumnVector) {
        int sign = arg1.sign;
        if (arg2 < 0.0) {
            sign *= -1;
            arg2 = -arg2;
        }
        int[] fields = arg1.fields;
        if (arg1.isYearMonthInterval()) {
            long result = (long)fields[0] * 12L + (long)fields[1];
            int months = (int)((result *= (long)arg2) % 12L);
            int years = 0;
            if ((result /= 12L) > Integer.MAX_VALUE) {
                throw new ValueArithmeticException(XQEMessageKeys.DAT_NumericOverflowError, arg1.toString(), ASTERISK, Double.toString(arg2), "integer");
            }
            years = (int)result;
            outputColumnVector.vector[i].set(sign, years, months);
        } else {
            double ms = (long)fields[0] * 86400000L + (long)fields[1] * 3600000L + (long)fields[2] * 60000L + (long)fields[3] * 1000L;
            double ns = (double)fields[4] * arg2;
            long days = (long)(ms *= arg2) / 86400000L;
            if (days > Integer.MAX_VALUE) {
                throw new ValueArithmeticException(XQEMessageKeys.DAT_NumericOverflowError, TimestampUtil.getIntervalString(arg1.dataType, sign, fields), ASTERISK, Double.toString(arg2), "integer");
            }
            int hours = (int)((ms %= 8.64E7) / 3600000.0);
            int minutes = (int)((ms %= 3600000.0) / 60000.0);
            int seconds = (int)((ms %= 60000.0) / 1000.0);
            int nanoseconds = (int)(ns + (ms %= 1000.0) * 1000000.0);
            outputColumnVector.vector[i].set(sign, (int)days, hours, minutes, seconds, nanoseconds);
            outputColumnVector.vector[i].normalize();
        }
    }

    public void divide(int i, IntervalColumnVector.IntervalStruct arg1, double arg2, IntervalColumnVector outputColumnVector) {
        int sign = arg1.sign;
        if (arg2 < 0.0) {
            sign *= -1;
            arg2 = -arg2;
        }
        int[] fields = arg1.fields;
        if (arg1.isYearMonthInterval()) {
            long result = (long)fields[0] * 12L + (long)fields[1];
            int months = (int)((result /= (long)arg2) % 12L);
            int years = (int)(result / 12L);
            outputColumnVector.vector[i].set(sign, years, months);
            outputColumnVector.vector[i].normalize();
        } else {
            double ms = (long)fields[0] * 86400000L + (long)fields[1] * 3600000L + (long)fields[2] * 60000L + (long)fields[3] * 1000L;
            double ns = (double)fields[4] / arg2;
            long days = (int)((ms /= arg2) / 8.64E7);
            int hours = (int)((ms %= 8.64E7) / 3600000.0);
            int minutes = (int)((ms %= 3600000.0) / 60000.0);
            int seconds = (int)((ms %= 60000.0) / 1000.0);
            int nanoseconds = (int)(ns + (ms %= 1000.0) * 1000000.0);
            outputColumnVector.vector[i].set(sign, (int)days, hours, minutes, seconds, nanoseconds);
            outputColumnVector.vector[i].normalize();
        }
    }

    public static void normalize(IDataType dataType, int sign, int[] fields) throws ValueConversionException {
        IntervalQualifier qualifier = ((IntervalType)dataType).getQualifier();
        switch (qualifier) {
            case INTERVAL_YEAR_TO_MONTH: {
                long result = (long)fields[0] * 12L + (long)fields[1];
                fields[1] = (int)(result % 12L);
                if ((result /= 12L) <= Integer.MAX_VALUE) {
                    fields[0] = (int)result;
                    break;
                }
                throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, dataType.toString(), TimestampUtil.getIntervalString(dataType, sign, fields), dataType.toString());
            }
            case INTERVAL_YEAR: {
                long result = (long)fields[0] * 12L + (long)fields[1];
                if ((result /= 12L) > Integer.MAX_VALUE) {
                    throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, dataType.toString(), TimestampUtil.getIntervalString(dataType, sign, fields), dataType.toString());
                }
                fields[0] = (int)result;
                fields[1] = 0;
                break;
            }
            case INTERVAL_MONTH: {
                long result = (long)fields[0] * 12L + (long)fields[1];
                if (result > Integer.MAX_VALUE) {
                    throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, dataType.toString(), TimestampUtil.getIntervalString(dataType, sign, fields), dataType.toString());
                }
                fields[1] = (int)result;
                fields[0] = 0;
                break;
            }
            case INTERVAL_DAY_TO_SECOND: {
                if (fields[4] >= 1000000000) {
                    fields[3] = fields[3] + fields[4] / 1000000000;
                    fields[4] = fields[4] % 1000000000;
                }
                if (fields[3] >= 60) {
                    fields[2] = fields[2] + fields[3] / 60;
                    fields[3] = fields[3] % 60;
                }
                if (fields[2] >= 60) {
                    fields[1] = fields[1] + fields[2] / 60;
                    fields[2] = fields[2] % 60;
                }
                if (fields[1] < 24) break;
                long result = (long)fields[0] + (long)(fields[1] / 24);
                if (result > Integer.MAX_VALUE) {
                    throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, dataType.toString(), TimestampUtil.getIntervalString(dataType, sign, fields), dataType.toString());
                }
                fields[0] = (int)result;
                fields[1] = fields[1] % 24;
                break;
            }
            case INTERVAL_DAY_TO_MINUTE: {
                if (fields[4] >= 1000000000) {
                    fields[3] = fields[3] + fields[4] / 1000000000;
                }
                fields[4] = 0;
                if (fields[3] >= 60) {
                    fields[2] = fields[2] + fields[3] / 60;
                }
                fields[3] = 0;
                if (fields[2] >= 60) {
                    fields[1] = fields[1] + fields[2] / 60;
                    fields[2] = fields[2] % 60;
                }
                if (fields[1] < 24) break;
                long result = (long)fields[0] + (long)(fields[1] / 24);
                if (result > Integer.MAX_VALUE) {
                    throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, dataType.toString(), TimestampUtil.getIntervalString(dataType, sign, fields), dataType.toString());
                }
                fields[0] = (int)result;
                fields[1] = fields[1] % 24;
                break;
            }
            case INTERVAL_DAY_TO_HOUR: {
                if (fields[4] >= 1000000000) {
                    fields[3] = fields[3] + fields[4] / 1000000000;
                }
                fields[4] = 0;
                if (fields[3] >= 60) {
                    fields[2] = fields[2] + fields[3] / 60;
                }
                fields[3] = 0;
                if (fields[2] >= 60) {
                    fields[1] = fields[1] + fields[2] / 60;
                }
                fields[2] = 0;
                if (fields[1] < 24) break;
                long result = (long)fields[0] + (long)(fields[1] / 24);
                if (result > Integer.MAX_VALUE) {
                    throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, dataType.toString(), TimestampUtil.getIntervalString(dataType, sign, fields), dataType.toString());
                }
                fields[0] = (int)result;
                fields[1] = fields[1] % 24;
                break;
            }
            case INTERVAL_DAY: {
                if (fields[4] >= 1000000000) {
                    fields[3] = fields[3] + fields[4] / 1000000000;
                }
                fields[4] = 0;
                if (fields[3] >= 60) {
                    fields[2] = fields[2] + fields[3] / 60;
                }
                fields[3] = 0;
                if (fields[2] >= 60) {
                    fields[1] = fields[1] + fields[2] / 60;
                }
                fields[2] = 0;
                if (fields[1] >= 24) {
                    long result = (long)fields[0] + (long)(fields[1] / 24);
                    if (result <= Integer.MAX_VALUE) {
                        fields[0] = (int)result;
                    } else {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, dataType.toString(), TimestampUtil.getIntervalString(dataType, sign, fields), dataType.toString());
                    }
                }
                fields[1] = 0;
                break;
            }
            case INTERVAL_HOUR_TO_SECOND: {
                long result;
                if (fields[4] >= 1000000000) {
                    fields[3] = fields[3] + fields[4] / 1000000000;
                    fields[4] = fields[4] % 1000000000;
                }
                if (fields[3] >= 60) {
                    fields[2] = fields[2] + fields[3] / 60;
                    fields[3] = fields[3] % 60;
                }
                if (fields[2] >= 60) {
                    result = (long)fields[1] + (long)(fields[2] / 60);
                    if (result > Integer.MAX_VALUE) {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, dataType.toString(), TimestampUtil.getIntervalString(dataType, sign, fields), dataType.toString());
                    }
                    fields[1] = (int)result;
                    fields[2] = fields[2] % 60;
                }
                if (fields[0] > 0) {
                    result = (long)fields[1] + (long)(fields[0] * 24);
                    if (result <= Integer.MAX_VALUE) {
                        fields[1] = (int)result;
                    } else {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, dataType.toString(), TimestampUtil.getIntervalString(dataType, sign, fields), dataType.toString());
                    }
                }
                fields[0] = 0;
                break;
            }
            case INTERVAL_HOUR_TO_MINUTE: {
                long result;
                if (fields[4] >= 1000000000) {
                    fields[3] = fields[3] + fields[4] / 1000000000;
                }
                fields[4] = 0;
                if (fields[3] >= 60) {
                    fields[2] = fields[2] + fields[3] / 60;
                }
                fields[3] = 0;
                if (fields[2] >= 60) {
                    result = (long)fields[1] + (long)(fields[2] / 60);
                    if (result > Integer.MAX_VALUE) {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, dataType.toString(), TimestampUtil.getIntervalString(dataType, sign, fields), dataType.toString());
                    }
                    fields[1] = (int)result;
                    fields[2] = fields[2] % 60;
                }
                if (fields[0] > 0) {
                    result = (long)fields[1] + (long)(fields[0] * 24);
                    if (result <= Integer.MAX_VALUE) {
                        fields[1] = (int)result;
                    } else {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, dataType.toString(), TimestampUtil.getIntervalString(dataType, sign, fields), dataType.toString());
                    }
                }
                fields[0] = 0;
                break;
            }
            case INTERVAL_HOUR: {
                long result;
                if (fields[4] >= 1000000000) {
                    fields[3] = fields[3] + fields[4] / 1000000000;
                }
                fields[4] = 0;
                if (fields[3] >= 60) {
                    fields[2] = fields[2] + fields[3] / 60;
                }
                fields[3] = 0;
                if (fields[2] >= 60) {
                    result = (long)fields[1] + (long)(fields[2] / 60);
                    if (result <= Integer.MAX_VALUE) {
                        fields[1] = (int)result;
                    } else {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, dataType.toString(), TimestampUtil.getIntervalString(dataType, sign, fields), dataType.toString());
                    }
                }
                fields[2] = 0;
                if (fields[0] > 0) {
                    result = (long)fields[1] + (long)(fields[0] * 24);
                    if (result <= Integer.MAX_VALUE) {
                        fields[1] = (int)result;
                    } else {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, dataType.toString(), TimestampUtil.getIntervalString(dataType, sign, fields), dataType.toString());
                    }
                }
                fields[0] = 0;
                break;
            }
            case INTERVAL_MINUTE_TO_SECOND: {
                long result;
                if (fields[4] >= 1000000000) {
                    fields[3] = fields[3] + fields[4] / 1000000000;
                    fields[4] = fields[4] % 1000000000;
                }
                if (fields[3] >= 60) {
                    result = (long)fields[2] + (long)(fields[3] / 60);
                    if (result > Integer.MAX_VALUE) {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, dataType.toString(), TimestampUtil.getIntervalString(dataType, sign, fields), dataType.toString());
                    }
                    fields[2] = (int)result;
                    fields[3] = fields[3] % 60;
                }
                if (fields[1] > 0) {
                    result = (long)fields[2] + (long)(fields[1] * 60);
                    if (result <= Integer.MAX_VALUE) {
                        fields[2] = (int)result;
                    } else {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, dataType.toString(), TimestampUtil.getIntervalString(dataType, sign, fields), dataType.toString());
                    }
                }
                fields[1] = 0;
                if (fields[0] > 0) {
                    result = (long)fields[2] + (long)(fields[0] * 1440);
                    if (result <= Integer.MAX_VALUE) {
                        fields[2] = (int)result;
                    } else {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, dataType.toString(), TimestampUtil.getIntervalString(dataType, sign, fields), dataType.toString());
                    }
                }
                fields[0] = 0;
                break;
            }
            case INTERVAL_MINUTE: {
                long result;
                if (fields[4] >= 1000000000) {
                    fields[3] = fields[3] + fields[4] / 1000000000;
                }
                fields[4] = 0;
                if (fields[3] >= 60) {
                    result = (long)fields[2] + (long)(fields[3] / 60);
                    if (result <= Integer.MAX_VALUE) {
                        fields[2] = (int)result;
                    } else {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, dataType.toString(), TimestampUtil.getIntervalString(dataType, sign, fields), dataType.toString());
                    }
                }
                fields[3] = 0;
                if (fields[1] > 0) {
                    result = (long)fields[2] + (long)(fields[1] * 60);
                    if (result <= Integer.MAX_VALUE) {
                        fields[2] = (int)result;
                    } else {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, dataType.toString(), TimestampUtil.getIntervalString(dataType, sign, fields), dataType.toString());
                    }
                }
                fields[1] = 0;
                if (fields[0] > 0) {
                    result = (long)fields[2] + (long)(fields[0] * 1440);
                    if (result <= Integer.MAX_VALUE) {
                        fields[2] = (int)result;
                    } else {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, dataType.toString(), TimestampUtil.getIntervalString(dataType, sign, fields), dataType.toString());
                    }
                }
                fields[0] = 0;
                break;
            }
            case INTERVAL_SECOND: {
                long result;
                if (fields[4] >= 1000000000) {
                    fields[3] = fields[3] + fields[4] / 1000000000;
                    fields[4] = fields[4] % 1000000000;
                }
                if (fields[2] > 0) {
                    result = (long)fields[3] + (long)(fields[2] * 60);
                    if (result <= Integer.MAX_VALUE) {
                        fields[3] = (int)result;
                    } else {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, dataType.toString(), TimestampUtil.getIntervalString(dataType, sign, fields), dataType.toString());
                    }
                }
                fields[2] = 0;
                if (fields[1] > 0) {
                    result = (long)fields[3] + (long)(fields[1] * 3600);
                    if (result <= Integer.MAX_VALUE) {
                        fields[3] = (int)result;
                    } else {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, dataType.toString(), TimestampUtil.getIntervalString(dataType, sign, fields), dataType.toString());
                    }
                }
                fields[1] = 0;
                if (fields[0] > 0) {
                    result = (long)fields[3] + (long)(fields[0] * 86400);
                    if (result <= Integer.MAX_VALUE) {
                        fields[3] = (int)result;
                    } else {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, dataType.toString(), TimestampUtil.getIntervalString(dataType, sign, fields), dataType.toString());
                    }
                }
                fields[0] = 0;
                break;
            }
        }
    }

    public static String getIntervalString(IDataType dataType, int sign, int[] fields) {
        String literal = null;
        StringBuilder b = new StringBuilder();
        if (dataType.getCCLTypeCode() == 17) {
            if (sign < 0) {
                b.append(HYPHEN);
            }
            switch (((IntervalType)dataType).getQualifier()) {
                case INTERVAL_YEAR: {
                    literal = Integer.toString(fields[0]);
                    break;
                }
                case INTERVAL_MONTH: {
                    literal = Integer.toString(fields[1]);
                    break;
                }
                case INTERVAL_YEAR_TO_MONTH: {
                    literal = String.format("%1$d-%2$02d", fields[0], fields[1]);
                    break;
                }
            }
            b.append(literal);
        } else {
            b.append(DateTimeValue.convertNanosToFractionalString(fields[4]));
            String nanoSecond = b.toString();
            b.setLength(0);
            if (sign < 0) {
                b.append(HYPHEN);
            }
            switch (((IntervalType)dataType).getQualifier()) {
                case INTERVAL_DAY: {
                    literal = Integer.toString(fields[0]);
                    break;
                }
                case INTERVAL_HOUR: {
                    literal = Integer.toString(fields[1]);
                    break;
                }
                case INTERVAL_MINUTE: {
                    literal = Integer.toString(fields[2]);
                    break;
                }
                case INTERVAL_SECOND: {
                    literal = String.format("%1$d%2$s", fields[3], nanoSecond);
                    break;
                }
                case INTERVAL_DAY_TO_HOUR: {
                    literal = String.format("%1$d %2$02d", fields[0], fields[1]);
                    break;
                }
                case INTERVAL_DAY_TO_MINUTE: {
                    literal = String.format("%1$d %2$02d:%3$02d", fields[0], fields[1], fields[2]);
                    break;
                }
                case INTERVAL_DAY_TO_SECOND: {
                    literal = String.format("%1$d %2$02d:%3$02d:%4$02d%5$s", fields[0], fields[1], fields[2], fields[3], nanoSecond);
                    break;
                }
                case INTERVAL_HOUR_TO_MINUTE: {
                    literal = String.format("%1$d:%2$02d", fields[1], fields[2]);
                    break;
                }
                case INTERVAL_HOUR_TO_SECOND: {
                    literal = String.format("%1$d:%2$02d:%3$02d%4$s", fields[1], fields[2], fields[3], nanoSecond);
                    break;
                }
                case INTERVAL_MINUTE_TO_SECOND: {
                    literal = String.format("%1$d:%2$02d%3$s", fields[2], fields[3], nanoSecond);
                    break;
                }
            }
            b.append(literal);
        }
        return b.toString();
    }

    public void parseTime(String value, TimestampColumnVector.UnixTimestamp unixTimestamp) {
        Matcher m = TimeValue.TIME_PATTERN.matcher(value);
        if (!m.matches()) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", value, "time");
        }
        String[] timeFields = value.split(":");
        int hour = Integer.parseInt(timeFields[0]);
        int minute = Integer.parseInt(timeFields[1]);
        timeFields = timeFields[2].split(PERIOD);
        int second = Integer.parseInt(timeFields[0]);
        int nanoseconds = 0;
        if (timeFields.length > 1) {
            StringBuilder tmpBuf = new StringBuilder(timeFields[1]);
            tmpBuf.append(DateTimeValue.ZEROS[9 - timeFields[1].length()]);
            nanoseconds = Integer.parseInt(tmpBuf.toString());
        }
        this.calendar.clear();
        this.calendar.set(11, hour);
        this.calendar.set(12, minute);
        this.calendar.set(13, second);
        unixTimestamp.set(this.calendar.getTimeInMillis(), nanoseconds);
    }

    public void parseTimeWithTZ(String value, TimestampColumnVector.UnixTimestamp unixTimestamp) {
        Matcher m = TimeWithTZValue.PATTERN.matcher(value);
        if (!m.matches()) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", value, "time with time zone");
        }
        int sign = 1;
        if (value.indexOf(HYPHEN) > 0) {
            sign = -1;
        }
        String[] list = value.split(PLUS_OR_MINUS);
        String[] timeFields = list[0].split(":");
        int hour = Integer.parseInt(timeFields[0]);
        int minute = Integer.parseInt(timeFields[1]);
        timeFields = timeFields[2].split(PERIOD);
        int second = Integer.parseInt(timeFields[0]);
        int nanoseconds = 0;
        if (timeFields.length > 1) {
            StringBuilder tmpBuf = new StringBuilder(timeFields[1]);
            tmpBuf.append(DateTimeValue.ZEROS[9 - timeFields[1].length()]);
            nanoseconds = Integer.parseInt(tmpBuf.toString());
        } else {
            nanoseconds = 0;
        }
        this.calendar.clear();
        int rawOffset = 0;
        if (list.length > 1) {
            String[] timeZoneFields = list[1].split(":");
            int tzHour = Integer.parseInt(timeZoneFields[0]);
            int tzMinute = 0;
            if (timeZoneFields.length == 2) {
                tzMinute = Integer.parseInt(timeZoneFields[1]);
            }
            rawOffset = (tzHour * 3600000 + tzMinute * 60000) * sign;
            String timeZoneID = TimeWithTZValue.createCustomTimeZoneID(sign, tzHour, tzMinute);
            this.calendar.setTimeZone(new SimpleTimeZone(rawOffset, timeZoneID));
        }
        this.calendar.set(11, hour);
        this.calendar.set(12, minute);
        this.calendar.set(13, second);
        unixTimestamp.set(this.calendar.getTimeInMillis(), nanoseconds, rawOffset);
    }

    public void parseTimestamp(String value, TimestampColumnVector.UnixTimestamp unixTimestamp) {
        Matcher m = TimestampValue.PATTERN.matcher(value);
        if (!m.matches()) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", value, "timestamp");
        }
        value = value.replace('T', ' ');
        String[] list = value.split(" ");
        String[] dateFields = list[0].split(HYPHEN);
        int year = Integer.parseInt(dateFields[0]);
        int month = Integer.parseInt(dateFields[1]) - 1;
        int day = Integer.parseInt(dateFields[2]);
        String[] timeFields = list[1].split(":");
        int hour = Integer.parseInt(timeFields[0]);
        int minute = Integer.parseInt(timeFields[1]);
        timeFields = timeFields[2].split(PERIOD);
        int second = Integer.parseInt(timeFields[0]);
        int nanoseconds = 0;
        if (timeFields.length > 1) {
            StringBuilder tmpBuf = new StringBuilder(timeFields[1]);
            tmpBuf.append(DateTimeValue.ZEROS[9 - timeFields[1].length()]);
            nanoseconds = Integer.parseInt(tmpBuf.toString());
        } else {
            nanoseconds = 0;
        }
        this.calendar.clear();
        this.calendar.set(1, year);
        this.calendar.set(2, month);
        this.calendar.set(5, day);
        this.calendar.set(11, hour);
        this.calendar.set(12, minute);
        this.calendar.set(13, second);
        unixTimestamp.set(this.calendar.getTimeInMillis(), nanoseconds);
    }

    public void parseTimestampWithTZ(String value, TimestampColumnVector.UnixTimestamp unixTimestamp) {
        Matcher m = TimestampWithTZValue.PATTERN.matcher(value);
        if (!m.matches()) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", value, "timestamp with time zone");
        }
        value = value.replace('T', ' ');
        String[] list = value.split(" ");
        String[] dateFields = list[0].split(HYPHEN);
        int year = Integer.parseInt(dateFields[0]);
        int month = Integer.parseInt(dateFields[1]) - 1;
        int day = Integer.parseInt(dateFields[2]);
        int nanoseconds = 0;
        int sign = 1;
        if (list[1].indexOf(HYPHEN) > 0) {
            sign = -1;
        }
        list = list[1].split(PLUS_OR_MINUS);
        String[] timeFields = list[0].split(":");
        int hour = Integer.parseInt(timeFields[0]);
        int minute = Integer.parseInt(timeFields[1]);
        timeFields = timeFields[2].split(PERIOD);
        int second = Integer.parseInt(timeFields[0]);
        boolean utcTime = false;
        if (timeFields.length > 1) {
            String nanoSecsStr = timeFields[1];
            if (nanoSecsStr.indexOf(90) > 0) {
                nanoSecsStr = nanoSecsStr.substring(0, nanoSecsStr.length() - 1);
                utcTime = true;
            }
            StringBuilder tmpBuf = new StringBuilder(nanoSecsStr);
            tmpBuf.append(DateTimeValue.ZEROS[9 - timeFields[1].length()]);
            nanoseconds = Integer.parseInt(tmpBuf.toString());
        } else {
            nanoseconds = 0;
        }
        int tzHour = 0;
        int tzMinute = 0;
        if (!utcTime) {
            String[] timeZoneFields = list[1].split(":");
            tzHour = Integer.parseInt(timeZoneFields[0]);
            tzMinute = 0;
            if (timeZoneFields.length == 2) {
                tzMinute = Integer.parseInt(timeZoneFields[1]);
            }
        }
        int rawOffset = (tzHour * 3600000 + tzMinute * 60000) * sign;
        String timeZoneID = TimeWithTZValue.createCustomTimeZoneID(sign, tzHour, tzMinute);
        this.calendar.clear();
        this.calendar.setTimeZone(new SimpleTimeZone(rawOffset, timeZoneID));
        this.calendar.set(1, year);
        this.calendar.set(2, month);
        this.calendar.set(5, day);
        this.calendar.set(11, hour);
        this.calendar.set(12, minute);
        this.calendar.set(13, second);
        unixTimestamp.set(this.calendar.getTimeInMillis(), nanoseconds, rawOffset);
    }

    public void parseYearMonthInterval(String ymValue, IntervalColumnVector.IntervalStruct intervalStruct) {
        int sign;
        Matcher m = IntervalYearMonthValue.PATTERN.matcher(ymValue);
        int years = 0;
        int months = 0;
        IntervalType dataType = (IntervalType)intervalStruct.dataType;
        if (m.matches()) {
            if (ymValue.charAt(0) == '-') {
                sign = -1;
                ymValue = ymValue.substring(1);
            } else if (ymValue.charAt(0) == '+') {
                sign = 1;
                ymValue = ymValue.substring(1);
            } else {
                sign = 1;
            }
            String[] list = ymValue.split(HYPHEN);
            IntervalQualifier qualifier = dataType.getQualifier();
            if (list.length > 1 && qualifier != IntervalQualifier.INTERVAL_YEAR_TO_MONTH) {
                throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", ymValue, dataType.toString());
            }
            int value = Integer.parseInt(list[0]);
            switch (qualifier) {
                case INTERVAL_YEAR_TO_MONTH: {
                    if (list.length != 2) {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", ymValue, dataType.toString());
                    }
                    months = Integer.parseInt(list[1]);
                    if (months > 11) {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", ymValue, dataType.toString());
                    }
                    years = value;
                    break;
                }
                case INTERVAL_YEAR: {
                    years = value;
                    break;
                }
                case INTERVAL_MONTH: {
                    months = value;
                    break;
                }
            }
        } else {
            try {
                Duration d = new Duration(ymValue);
                years = d.getYears();
                months = d.getMonths();
                sign = d.isNegative() ? -1 : 1;
            }
            catch (IllegalArgumentException e) {
                throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, (Throwable)e, "string", ymValue, dataType.toString());
            }
        }
        intervalStruct.set(sign, years, months);
    }

    public void parseDayTimeInterval(String dtValue, IntervalColumnVector.IntervalStruct intervalStruct) {
    }
}

