/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorTabularIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.concurrent.ThreadPool;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.concurrent.LinkedBlockingQueue;
import org.dom4j.Element;

public class XVectorCollect
extends XTabularResultSet {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_PACKETSIZE = "packetSize";
    private static final String ATTRIBUTE_DOP = "dop";
    private static final int PACKET_SIZE = 50;
    private int packetSize = 50;
    private final Thread mainThread = Thread.currentThread();
    private int dop = Runtime.getRuntime().availableProcessors();
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    @Override
    protected IValue executeImpl(XDataContext context) throws XQERuntimeException {
        return new TabularHybridResultSet(context, new XCollectResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501045;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_DOP, this.dop);
        trace.attribute(ATTRIBUTE_PACKETSIZE, this.packetSize);
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }

    public void setDop(int theDop) {
        this.dop = theDop;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        String aPacketSize = inputNode.attributeValue(ATTRIBUTE_PACKETSIZE);
        String aDop = inputNode.attributeValue(ATTRIBUTE_DOP);
        if (aPacketSize != null) {
            this.packetSize = Integer.valueOf(aPacketSize);
        }
        if (aDop != null) {
            this.dop = Integer.valueOf(aDop);
        }
        super.capture(env, inputNode);
    }

    private class Producer
    implements Runnable {
        private XDataContext context;
        private XVectorRowBatch batch;
        private LinkedBlockingQueue<XVectorRowBatch> queue;
        private ITabularIterator tabIt;

        Producer(XDataContext theContext, ITabularIterator theTabIt, LinkedBlockingQueue<XVectorRowBatch> theQueue) {
            this.context = theContext;
            this.tabIt = theTabIt;
            this.queue = theQueue;
        }

        private void pushBatch() {
            try {
                this.queue.put(this.batch.copy());
            }
            catch (InterruptedException e) {
                mErrorLogger.log(e);
            }
        }

        @Override
        public void run() {
            ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(this.context.getEnvironment());
            try {
                while (true) {
                    this.batch = (XVectorRowBatch)this.tabIt.nextBatch();
                    if (this.batch.eod) break;
                    this.pushBatch();
                }
                this.pushBatch();
            }
            catch (XQERuntimeException e) {
                XVectorCollect.this.mainThread.interrupt();
            }
            finally {
                executionEnvironmentContext.exit();
            }
        }
    }

    private final class XCollectResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private IHybridResultSet iResultSet;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        XCollectResultSet(XDataContext context) {
            super(context, XVectorCollect.this.getId());
            IExecutionEnvironment execEnv = context.getEnvironment();
            try {
                context = execEnv.pushDataContext();
                this.iResultSet = (IHybridResultSet)((IExecutable)((Object)XVectorCollect.this.getChild(0))).execute(context);
            }
            finally {
                execEnv.popDataContext(context);
            }
            super.setTabularRowsetInfo(this.iResultSet.getTabularRowsetInfo());
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XVectorCollectIterator(this.getDataContext());
        }

        @Override
        public void releaseImpl() {
        }

        private final class XVectorCollectIterator
        extends XVectorTabularIterator {
            private IHybridResultSet[] resultSets;
            private int eodCounter;
            private LinkedBlockingQueue<XVectorRowBatch> queue;
            private XVectorRowBatch batch;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private XVectorCollectIterator(XDataContext context) {
                super(context, XVectorCollect.this.getId(), XCollectResultSet.this.rowsetInfo);
                this.eodCounter = 0;
                this.startTimer();
                IExecutionEnvironment execEnv = context.getEnvironment();
                this.queue = new LinkedBlockingQueue(XVectorCollect.this.dop);
                this.resultSets = new IHybridResultSet[XVectorCollect.this.dop];
                IExecutable child = (IExecutable)((Object)XVectorCollect.this.getChild(0));
                for (int i = 0; i < XVectorCollect.this.dop; ++i) {
                    if (i == 0) {
                        this.resultSets[i] = XCollectResultSet.this.iResultSet;
                    } else {
                        XDataContext subContext = execEnv.pushDataContext();
                        try {
                            this.resultSets[i] = (IHybridResultSet)child.execute(subContext);
                        }
                        finally {
                            execEnv.popDataContext(subContext);
                        }
                    }
                    ThreadPool.getInstance().submit(new Producer(context, this.resultSets[i].getTabularIterator(), this.queue));
                }
                this.stopTimer();
            }

            @Override
            public Object nextBatch() {
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                try {
                    do {
                        this.batch = this.queue.take();
                    } while (this.batch.eod && ++this.eodCounter != XVectorCollect.this.dop);
                }
                catch (InterruptedException e) {
                    mErrorLogger.log(e);
                }
                return this.batch;
            }

            @Override
            public long getIndex() {
                return this.nRows;
            }

            @Override
            public void release() {
                super.release();
                for (int i = 0; i < XVectorCollect.this.dop; ++i) {
                    IHybridResultSet resultSet = this.resultSets[i];
                    if (resultSet == null) continue;
                    resultSet.release();
                }
            }
        }
    }
}

