/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class XVectorColumn
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    protected int columnNo;

    public XVectorColumn() {
    }

    public XVectorColumn(int theColumnNo) {
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        IRow row = context.getCurrentRow();
        if (row != null && !row.isNull()) {
            return row.getColumn(this.columnNo);
        }
        return null;
    }

    @Override
    public int getColumnNo() {
        return this.columnNo;
    }

    public void setColumnNo(int theColumnNo) {
        this.columnNo = theColumnNo;
    }

    @Override
    public IDataType getDataType(IRowsetInfo rowsetInfo, int index) {
        return rowsetInfo.getColumnInfo(this.columnNo).getDataType();
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", String.valueOf(this.columnNo));
        trace.attribute("dataType", this.dataType.toString());
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.dataType = DataTypeFactory.getType(inputNode.attribute("dataType").getValue());
    }
}

