/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.IVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorTabularIterator;
import com.cognos.xqe.trace.XQETrace;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import org.dom4j.Element;

public class XVectorCreateBloomFilter
extends XTabularResultSet {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_COLUMNNO = "columnNo";
    private int columnNo;
    private String name;
    private static final int ROW_ESTIMATE = 10000;

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XVectorCreateBloomFilterResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501200;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.name = inputNode.attributeValue(ATTRIBUTE_NAME);
        this.columnNo = Integer.valueOf(inputNode.attributeValue(ATTRIBUTE_COLUMNNO));
        super.capture(env, inputNode);
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_COLUMNNO, this.columnNo);
    }

    private void updateBloomFilter(XDataContext context, XVectorRowBatch batch, BloomFilter<byte[]> bloomFilter) {
        block12: {
            boolean[] inputIsNull;
            ColumnVector inputColumnVector;
            int[] selected;
            int n;
            block11: {
                n = batch.size;
                if (n == 0) {
                    return;
                }
                selected = batch.selected;
                inputColumnVector = batch.columns[this.columnNo];
                inputIsNull = inputColumnVector.isNull;
                if (!inputColumnVector.isRepeating) break block11;
                if (inputIsNull[0]) break block12;
                bloomFilter.put((Object)inputColumnVector.getBytes(0));
                break block12;
            }
            if (inputColumnVector.noNulls) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        bloomFilter.put((Object)inputColumnVector.getBytes(selected[j]));
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        bloomFilter.put((Object)inputColumnVector.getBytes(i));
                    }
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    if (inputIsNull[i]) continue;
                    bloomFilter.put((Object)inputColumnVector.getBytes(i));
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    if (inputIsNull[i]) continue;
                    bloomFilter.put((Object)inputColumnVector.getBytes(i));
                }
            }
        }
    }

    private final class XVectorCreateBloomFilterResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private IHybridResultSet iResultSet;

        XVectorCreateBloomFilterResultSet(XDataContext context) {
            super(context, XVectorCreateBloomFilter.this.getId());
            XVectorCreateBloomFilter.this.contextNo = XVectorCreateBloomFilter.this.getContextNo();
            this.iResultSet = (IHybridResultSet)((IExecutable)((Object)XVectorCreateBloomFilter.this.getChild(0))).execute(this.getDataContext());
            super.setTabularRowsetInfo(this.iResultSet.getTabularRowsetInfo());
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XVectorCreateBloomFilterIterator(this.getDataContext());
        }

        @Override
        public XVectorContext getVectorizationContext() {
            return ((IVectorContext)((Object)this.iResultSet)).getVectorizationContext();
        }

        @Override
        public void releaseImpl() {
            if (this.iResultSet != null) {
                this.iResultSet.release();
                this.iResultSet = null;
            }
            this.rowsetInfo = null;
        }

        private final class XVectorCreateBloomFilterIterator
        extends XVectorTabularIterator {
            private ITabularIterator tabIt;
            private BloomFilter<byte[]> bloomFilter;

            private XVectorCreateBloomFilterIterator(XDataContext context) {
                super(context, XVectorCreateBloomFilter.this.getId(), XVectorCreateBloomFilterResultSet.this.rowsetInfo);
                try {
                    this.startTimer();
                    this.tabIt = XVectorCreateBloomFilterResultSet.this.iResultSet.getTabularIterator();
                    this.bloomFilter = BloomFilter.create((Funnel)Funnels.byteArrayFunnel(), (int)10000);
                    context.setBloomFilter(XVectorCreateBloomFilter.this.name, this.bloomFilter);
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextBatch() {
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                this.batch = (XVectorRowBatch)this.tabIt.nextBatch();
                if (!this.batch.eod) {
                    XVectorCreateBloomFilter.this.updateBloomFilter(this.context, this.batch, (BloomFilter<byte[]>)this.bloomFilter);
                }
                return this.batch;
            }

            @Override
            public long getIndex() {
                return this.tabIt.getIndex();
            }

            @Override
            public void release() {
                if (this.tabIt != null) {
                    try {
                        this.tabIt.release();
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.tabIt = null;
                    }
                }
                super.release();
            }
        }
    }
}

