/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.ColumnInfo;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.XNodeFactory;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.runtree.relational.vectorization.XVectorBatchPartition;
import com.cognos.xqe.runtree.relational.vectorization.XVectorBatchPartitionSet;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorSetFunction;
import com.cognos.xqe.runtree.relational.vectorization.XVectorTabularIterator;
import com.cognos.xqe.trace.XQETrace;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

public class XVectorGroupBy
extends XTabularResultSet {
    private static final long serialVersionUID = 1L;
    protected static final String ELEMENT_OUTPUTLIST = "OutputList";
    protected static final String ELEMENT_FUNCTIONLIST = "FunctionList";
    protected static final String ELEMENT_GROUPBYLIST = "GroupBy";
    protected static final String ELEMENT_NONGROUPBYLIST = "NonGroupBy";
    protected static final String ELEMENT_COLUMN = "Column";
    protected static final String ATTRIBUTE_COLUMNNO = "columnNo";
    protected XVectorExpression[] outputList;
    protected XVectorSetFunction[] functionList;
    protected int[] groupByList;
    protected int[] nonGroupByList;

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XVectorGroupByResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501172;
    }

    @Override
    public XVectorContext getVectorizationContext() {
        return this.vContext;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        int i;
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        this.vContext.dumpInfo(trace);
        trace.beginElement(ELEMENT_OUTPUTLIST);
        for (i = 0; i < this.outputList.length; ++i) {
            this.outputList[i].dump(trace);
        }
        trace.endElement();
        trace.beginElement(ELEMENT_FUNCTIONLIST);
        for (i = 0; i < this.functionList.length; ++i) {
            this.functionList[i].dump(trace);
        }
        trace.endElement();
        trace.beginElement(ELEMENT_GROUPBYLIST);
        for (i = 0; i < this.groupByList.length; ++i) {
            trace.beginElement(ELEMENT_COLUMN);
            trace.attribute(ATTRIBUTE_COLUMNNO, this.groupByList[i]);
            trace.endElement();
        }
        trace.endElement();
        trace.beginElement(ELEMENT_NONGROUPBYLIST);
        for (i = 0; i < this.nonGroupByList.length; ++i) {
            trace.beginElement(ELEMENT_COLUMN);
            trace.attribute(ATTRIBUTE_COLUMNNO, this.nonGroupByList[i]);
            trace.endElement();
        }
        trace.endElement();
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        XVectorExpression xNode;
        int i;
        XNodeFactory nodeFactory = (XNodeFactory)env.getNodeFactory();
        Iterator it = inputNode.elements().iterator();
        Element child = (Element)it.next();
        this.vContext = new XVectorContext();
        this.vContext.capture(env, child);
        child = (Element)it.next();
        List exprList = child.elements();
        this.outputList = new XVectorExpression[exprList.size()];
        for (i = 0; i < exprList.size(); ++i) {
            child = (Element)exprList.get(i);
            xNode = (XVectorExpression)nodeFactory.createNodeByName(child.getName());
            xNode.capture(env, child);
            this.outputList[i] = xNode;
        }
        child = (Element)it.next();
        exprList = child.elements();
        this.functionList = new XVectorSetFunction[exprList.size()];
        for (i = 0; i < exprList.size(); ++i) {
            child = (Element)exprList.get(i);
            xNode = (XVectorSetFunction)nodeFactory.createNodeByName(child.getName());
            xNode.capture(env, child);
            this.functionList[i] = xNode;
        }
        child = (Element)it.next();
        exprList = child.elements();
        if (exprList != null) {
            this.groupByList = new int[exprList.size()];
            for (i = 0; i < exprList.size(); ++i) {
                child = (Element)exprList.get(i);
                this.groupByList[i] = Integer.valueOf(child.attributeValue(ATTRIBUTE_COLUMNNO));
            }
        } else {
            this.groupByList = new int[0];
        }
        if ((exprList = (child = (Element)it.next()).elements()) != null) {
            this.nonGroupByList = new int[exprList.size()];
            for (i = 0; i < exprList.size(); ++i) {
                child = (Element)exprList.get(i);
                this.nonGroupByList[i] = Integer.valueOf(child.attributeValue(ATTRIBUTE_COLUMNNO));
            }
        } else {
            this.nonGroupByList = new int[0];
        }
        child = (Element)it.next();
        XNode xChild = (XNode)nodeFactory.createNodeByName(child.getName());
        xChild.capture(env, child);
        this.addChild(xChild);
    }

    public void setOutputList(XVectorExpression[] theOutputList) {
        this.outputList = theOutputList;
    }

    public void setFunctionList(XVectorSetFunction[] theFunctionList) {
        this.functionList = theFunctionList;
    }

    public void setGroupByList(int[] theGroupByList) {
        this.groupByList = theGroupByList;
    }

    public void setNonGroupByList(int[] theNonGroupByList) {
        this.nonGroupByList = theNonGroupByList;
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.outputList != null) {
            ctx.elementProperty(ELEMENT_OUTPUTLIST, this.outputList);
        }
        if (this.functionList != null) {
            ctx.elementProperty(ELEMENT_FUNCTIONLIST, this.functionList);
        }
        if (this.groupByList != null) {
            ctx.elementProperty(ELEMENT_GROUPBYLIST, this.groupByList);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_OUTPUTLIST)) {
            Object val = ctx.elementValue(node);
            this.outputList = (XVectorExpression[])val;
        } else if (pname.equals(ELEMENT_FUNCTIONLIST)) {
            Object val = ctx.elementValue(node);
            this.functionList = (XVectorSetFunction[])val;
        } else if (pname.equals(ELEMENT_GROUPBYLIST)) {
            Object val = ctx.elementValue(node);
            this.groupByList = (int[])val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    protected class XVectorGroupByResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private static final String C = "C";
        protected ITabularResultSet iResultSet;
        protected IRowsetInfo tRowsetInfo;

        public XVectorGroupByResultSet(XDataContext context) {
            super(context, XVectorGroupBy.this.getId());
            try {
                int i;
                this.iResultSet = (ITabularResultSet)((IExecutable)((Object)XVectorGroupBy.this.getChild(0))).execute(this.getDataContext());
                IRowsetInfo iRowsetInfo = this.iResultSet.getTabularRowsetInfo();
                int nColumns = 0;
                this.tRowsetInfo = new RowsetInfo();
                for (i = 0; i < XVectorGroupBy.this.groupByList.length; ++i) {
                    this.tRowsetInfo.addColumnInfo(new ColumnInfo(C + nColumns++, iRowsetInfo.getColumnInfo(XVectorGroupBy.this.groupByList[i]).getDataType()));
                }
                for (i = 0; i < XVectorGroupBy.this.nonGroupByList.length; ++i) {
                    this.tRowsetInfo.addColumnInfo(new ColumnInfo(C + nColumns++, iRowsetInfo.getColumnInfo(XVectorGroupBy.this.nonGroupByList[i]).getDataType()));
                }
                for (i = 0; i < XVectorGroupBy.this.functionList.length; ++i) {
                    this.tRowsetInfo.addColumnInfo(new ColumnInfo(C + nColumns++, XVectorGroupBy.this.functionList[i].getDataType(iRowsetInfo, -1)));
                }
                for (XVectorSetFunction xVectorSetFunction : XVectorGroupBy.this.functionList) {
                    xVectorSetFunction.open(context, iRowsetInfo);
                }
                this.rowsetInfo = new RowsetInfo();
                for (int i2 = 0; i2 < XVectorGroupBy.this.outputList.length; ++i2) {
                    this.rowsetInfo.addColumnInfo(new ColumnInfo(C + i2, XVectorGroupBy.this.outputList[i2].getDataType(this.tRowsetInfo, i2)));
                }
                for (XVectorExpression xVectorExpression : XVectorGroupBy.this.outputList) {
                    xVectorExpression.open(context, this.tRowsetInfo);
                }
            }
            catch (RuntimeException e) {
                this.release();
                throw e;
            }
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XVectorGroupByIterator(this.getDataContext());
        }

        @Override
        public void releaseImpl() {
            if (this.iResultSet != null) {
                this.iResultSet.release();
                this.iResultSet = null;
            }
        }

        private final class XVectorGroupByIterator
        extends XVectorTabularIterator {
            private ITabularIterator tabIt;
            private boolean eod;
            private XVectorRowBatch tempRowBatch;
            private XVectorBatchPartitionSet partitionSet;

            private XVectorGroupByIterator(XDataContext context) {
                super(context, XVectorGroupBy.this.getId(), XVectorGroupByResultSet.this.rowsetInfo);
                this.partitionSet = new XVectorBatchPartitionSet();
                try {
                    this.startTimer();
                    XVectorGroupBy.this.contextNo = XVectorGroupBy.this.getContextNo();
                    this.tabIt = XVectorGroupByResultSet.this.iResultSet.getTabularIterator();
                    this.tempRowBatch = XVectorRowBatchUtil.createRowBatch(XVectorGroupByResultSet.this.tRowsetInfo, context.getLocalCollator(), 1);
                    this.batch = XVectorRowBatchUtil.createRowBatch(XVectorGroupBy.this.vContext, XVectorGroupByResultSet.this.rowsetInfo, context.getLocalCollator());
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextBatch() {
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                XVectorRowBatch inputBatch = null;
                this.batch.reset();
                if (this.eod) {
                    if (this.partitionSet.size() == 1) {
                        this.processPartition(this.partitionSet.remove());
                    } else {
                        this.batch.eod = true;
                    }
                    return this.batch;
                }
                while (true) {
                    if (this.partitionSet.size() > 1 && this.batch.size != this.batch.maxBatchSize) {
                        this.processPartition(this.partitionSet.remove());
                        continue;
                    }
                    if (this.batch.size == this.batch.maxBatchSize) break;
                    inputBatch = (XVectorRowBatch)this.tabIt.nextBatch();
                    if (inputBatch.eod) {
                        if (this.batch.size < this.batch.maxBatchSize && this.partitionSet.size() == 1) {
                            this.processPartition(this.partitionSet.remove());
                        }
                        this.eod = true;
                        if (this.batch.size != 0 || XVectorGroupBy.this.groupByList.length != 0) break;
                        this.buildSingleRow();
                        break;
                    }
                    this.processBatch(inputBatch);
                }
                if (this.batch.size == 0 && this.eod) {
                    this.batch.eod = true;
                }
                return this.batch;
            }

            private void processBatch(XVectorRowBatch inputBatch) {
                this.partitionSet.assignPartitions(XVectorGroupBy.this.functionList, inputBatch, XVectorGroupBy.this.groupByList, XVectorGroupBy.this.nonGroupByList);
                for (int i = 0; i < XVectorGroupBy.this.functionList.length; ++i) {
                    XVectorGroupBy.this.functionList[i].aggregate(this.context, this.partitionSet.getPartitions(), i, inputBatch);
                }
            }

            private void buildSingleRow() {
                int i;
                this.tempRowBatch.reset();
                for (i = 0; i < XVectorGroupBy.this.functionList.length; ++i) {
                    XVectorGroupBy.this.functionList[i].getResult(this.context, this.tempRowBatch, XVectorGroupBy.this.groupByList.length + i, XVectorGroupBy.this.functionList[i].getAggregateState());
                }
                for (i = 0; i < XVectorGroupBy.this.outputList.length; ++i) {
                    XVectorGroupBy.this.outputList[i].evaluate(this.context, this.tempRowBatch);
                }
                for (i = 0; i < XVectorGroupBy.this.outputList.length; ++i) {
                    this.batch.columns[i].assign(this.batch.size, this.tempRowBatch.columns[XVectorGroupBy.this.outputList[i].getColumnNo()], 0);
                }
                ++this.batch.size;
            }

            private void processPartition(XVectorBatchPartition partition) {
                int i;
                this.tempRowBatch.reset();
                this.tempRowBatch.copyValues(partition.getKeys(), 0, 0, XVectorGroupBy.this.groupByList);
                this.tempRowBatch.copyValues(partition.getKeys(), XVectorGroupBy.this.groupByList.length, 0, XVectorGroupBy.this.nonGroupByList);
                for (i = 0; i < XVectorGroupBy.this.functionList.length; ++i) {
                    XVectorGroupBy.this.functionList[i].getResult(this.context, this.tempRowBatch, XVectorGroupBy.this.groupByList.length + XVectorGroupBy.this.nonGroupByList.length + i, partition.getAggregateState(i));
                }
                for (i = 0; i < XVectorGroupBy.this.outputList.length; ++i) {
                    XVectorGroupBy.this.outputList[i].evaluate(this.context, this.tempRowBatch);
                }
                for (i = 0; i < XVectorGroupBy.this.outputList.length; ++i) {
                    this.batch.columns[i].assign(this.batch.size, this.tempRowBatch.columns[XVectorGroupBy.this.outputList[i].getColumnNo()], 0);
                }
                ++this.batch.size;
            }

            @Override
            public long getIndex() {
                return this.tabIt.getIndex();
            }

            @Override
            public void release() {
                if (this.tabIt != null) {
                    try {
                        this.tabIt.release();
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.tabIt = null;
                    }
                }
                super.release();
            }

            @Override
            public Object getVectorizationContext() {
                return XVectorGroupBy.this.vContext;
            }
        }
    }
}

