/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.MemoryBookKeeper;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.util.FileBasedPersistedResultSet;
import com.cognos.xqe.runtree.relational.vectorization.XVectorBatchPartition;
import com.cognos.xqe.runtree.relational.vectorization.XVectorBatchPartitionSet;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorGroupBy;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorTabularIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import gnu.trove.map.hash.THashMap;
import java.util.Iterator;
import java.util.Map;

public class XVectorHashGroupBy
extends XVectorGroupBy {
    private static final long serialVersionUID = 1L;

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XVectorHashGroupByResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501189;
    }

    @Override
    public XVectorContext getVectorizationContext() {
        return this.vContext;
    }

    private final class XVectorHashGroupByResultSet
    extends XVectorGroupBy.XVectorGroupByResultSet {
        XVectorHashGroupByResultSet(XDataContext theContext) {
            super(theContext);
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XVectorHashGroupByIterator(this.getDataContext());
        }

        private final class XVectorHashGroupByIterator
        extends XVectorTabularIterator {
            private static final int INITIAL_CAPACITY = 1000;
            private static final int SET_FUNCTION_STATE_SIZE = 300;
            private static final String MEMORY_MESSAGE_FORMAT = "Total Java Memory: %d MB, Free Calc memory: %d MB, Free Java memory: %d MB";
            private Map<GroupingKeys, XVectorBatchPartition> hashMap;
            private long memory;
            private XTabularIterator tabIt;
            private boolean eod;
            private XVectorBatchPartitionSet partitionSet;
            private Iterator<Map.Entry<GroupingKeys, XVectorBatchPartition>> hashIterator;
            private XVectorRowBatch tempRowBatch;

            private XVectorHashGroupByIterator(XDataContext context) {
                super(context, XVectorHashGroupBy.this.getId(), XVectorHashGroupByResultSet.this.rowsetInfo);
                this.memory = 0L;
                this.tabIt = null;
                this.partitionSet = new XVectorBatchPartitionSet();
                this.hashIterator = null;
                try {
                    this.startTimer();
                    XVectorHashGroupBy.this.contextNo = XVectorHashGroupBy.this.getContextNo();
                    this.hashMap = new THashMap(1000);
                    this.tabIt = (XTabularIterator)XVectorHashGroupByResultSet.this.iResultSet.getTabularIterator();
                    this.tempRowBatch = XVectorRowBatchUtil.createRowBatch(XVectorHashGroupByResultSet.this.tRowsetInfo, context.getLocalCollator(), 1);
                    this.batch = XVectorRowBatchUtil.createRowBatch(XVectorHashGroupBy.this.vContext, XVectorHashGroupByResultSet.this.rowsetInfo, context.getLocalCollator());
                }
                catch (RuntimeException e) {
                    if (this.tabIt != null) {
                        this.tabIt.release();
                    }
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextBatch() {
                if (this.hashIterator == null) {
                    this.loadHash();
                    this.hashIterator = this.hashMap.entrySet().iterator();
                }
                this.batch.reset();
                if (this.eod) {
                    this.batch.eod = true;
                    return this.batch;
                }
                while (this.batch.size != this.batch.maxBatchSize) {
                    int i;
                    if (!this.hashIterator.hasNext()) {
                        this.context.getMemoryManager().releaseMemory(this.memory);
                        this.hashMap.clear();
                        this.memory = 0L;
                        if (this.tabIt != null) {
                            this.loadHash();
                            this.hashIterator = this.hashMap.entrySet().iterator();
                            if (!this.hashIterator.hasNext()) {
                                this.eod = true;
                                break;
                            }
                        } else {
                            this.eod = true;
                            break;
                        }
                    }
                    Map.Entry<GroupingKeys, XVectorBatchPartition> entry = this.hashIterator.next();
                    GroupingKeys hashKey = entry.getKey();
                    XVectorBatchPartition partition = entry.getValue();
                    this.tempRowBatch.reset();
                    this.tempRowBatch.copyValues(hashKey.batch, 0, hashKey.index, XVectorHashGroupBy.this.groupByList);
                    this.tempRowBatch.copyValues(hashKey.batch, XVectorHashGroupBy.this.groupByList.length, hashKey.index, XVectorHashGroupBy.this.nonGroupByList);
                    for (i = 0; i < XVectorHashGroupBy.this.functionList.length; ++i) {
                        XVectorHashGroupBy.this.functionList[i].getResult(this.context, this.tempRowBatch, XVectorHashGroupBy.this.groupByList.length + XVectorHashGroupBy.this.nonGroupByList.length + i, partition.getAggregateState(i));
                    }
                    for (i = 0; i < XVectorHashGroupBy.this.outputList.length; ++i) {
                        XVectorHashGroupBy.this.outputList[i].evaluate(this.context, this.tempRowBatch);
                    }
                    for (i = 0; i < XVectorHashGroupBy.this.outputList.length; ++i) {
                        this.batch.columns[i].assign(this.batch.size, this.tempRowBatch.columns[XVectorHashGroupBy.this.outputList[i].getColumnNo()], 0);
                    }
                    ++this.batch.size;
                }
                if (this.batch.size == 0 && this.eod) {
                    this.batch.eod = true;
                }
                return this.batch;
            }

            @Override
            public long getIndex() {
                return -1L;
            }

            @Override
            public void release() {
                try {
                    if (this.tabIt != null) {
                        this.tabIt.release();
                    }
                }
                catch (Exception ex) {
                    mErrorLogger.log(ex);
                }
                finally {
                    this.tabIt = null;
                }
                this.hashMap = null;
                this.hashIterator = null;
                if (this.memory > 0L) {
                    this.context.getMemoryManager().releaseMemory(this.memory);
                    this.memory = 0L;
                }
                super.release();
            }

            private void loadHash() {
                GroupingKeys hashKey = new GroupingKeys();
                FileBasedPersistedResultSet scan = null;
                XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Memory", LogLevel.TRACE);
                Runtime rt = Runtime.getRuntime();
                logger.log(String.format("VectorHashGroupBy - start building hash table. Total Java Memory: %d MB, Free Calc memory: %d MB, Free Java memory: %d MB", rt.totalMemory() / 0x100000L, MemoryBookKeeper.getAvailableMemory() / 0x100000L, (rt.maxMemory() - (rt.totalMemory() - rt.freeMemory())) / 0x100000L));
                while (true) {
                    XVectorRowBatch inputBatch;
                    try {
                        inputBatch = (XVectorRowBatch)this.tabIt.nextBatch();
                    }
                    catch (OperationCanceledException e) {
                        if (scan != null) {
                            scan.release();
                        }
                        this.release();
                        throw e;
                    }
                    if (inputBatch.eod) {
                        XVectorContext vc = XVectorHashGroupBy.this.vContext;
                        if (null != this.tabIt.getVectorizationContext()) {
                            vc = (XVectorContext)this.tabIt.getVectorizationContext();
                        }
                        this.tabIt.release();
                        this.tabIt = null;
                        if (scan == null) break;
                        this.tabIt = scan.getVectorizedIterator(XVectorHashGroupByResultSet.this.iResultSet.getTabularRowsetInfo(), vc);
                        scan = null;
                        break;
                    }
                    if (inputBatch.size == 0) continue;
                    inputBatch = inputBatch.copy();
                    if (scan == null) {
                        scan = this.processBatch(hashKey, inputBatch);
                        continue;
                    }
                    this.processBatchToScan(scan, hashKey, inputBatch);
                }
            }

            private FileBasedPersistedResultSet processBatch(GroupingKeys hashKey, XVectorRowBatch inputBatch) {
                long memoryRequired;
                FileBasedPersistedResultSet scan = null;
                long memoryEstimate = memoryRequired = (long)inputBatch.sizeOf();
                boolean sameGroupingKeys = true;
                for (int i = 0; i < XVectorHashGroupBy.this.groupByList.length; ++i) {
                    if (inputBatch.columns[XVectorHashGroupBy.this.groupByList[i]].isRepeating) continue;
                    sameGroupingKeys = false;
                    break;
                }
                if (sameGroupingKeys) {
                    if (inputBatch.selectedInUse) {
                        hashKey.set(inputBatch, inputBatch.selected[0]);
                    } else {
                        hashKey.set(inputBatch, 0);
                    }
                    XVectorBatchPartition partition = this.hashMap.get(hashKey);
                    if (partition == null) {
                        boolean forced;
                        memoryEstimate = memoryEstimate + (long)hashKey.sizeOf() + (long)(300 * XVectorHashGroupBy.this.functionList.length);
                        boolean bl = forced = this.hashMap.size() == 0;
                        if (!this.context.getMemoryManager().allocateMemory(memoryEstimate, forced)) {
                            this.logMemoryEvent();
                            scan = new FileBasedPersistedResultSet(XVectorHashGroupByResultSet.this.iResultSet.getTabularRowsetInfo().getDataType(), this.context);
                            this.processBatchToScan(scan, hashKey, inputBatch);
                            return scan;
                        }
                        this.memory += memoryEstimate;
                        partition = new XVectorBatchPartition(XVectorHashGroupBy.this.functionList);
                        this.hashMap.put(hashKey.copy(), partition);
                    }
                    for (int i = 0; i < XVectorHashGroupBy.this.functionList.length; ++i) {
                        XVectorHashGroupBy.this.functionList[i].aggregate(this.context, partition, i, inputBatch);
                    }
                } else {
                    int i;
                    boolean forced;
                    boolean bl = forced = this.hashMap.size() == 0;
                    if (!this.context.getMemoryManager().allocateMemory(memoryEstimate += (long)((hashKey.sizeOf() + 300 * XVectorHashGroupBy.this.functionList.length) * this.batch.size), forced)) {
                        this.logMemoryEvent();
                        scan = new FileBasedPersistedResultSet(XVectorHashGroupByResultSet.this.iResultSet.getTabularRowsetInfo().getDataType(), this.context);
                        this.processBatchToScan(scan, hashKey, inputBatch);
                        return scan;
                    }
                    this.memory += memoryEstimate;
                    for (i = 0; i < inputBatch.size; ++i) {
                        if (inputBatch.selectedInUse) {
                            hashKey.set(inputBatch, inputBatch.selected[i]);
                        } else {
                            hashKey.set(inputBatch, i);
                        }
                        XVectorBatchPartition partition = this.hashMap.get(hashKey);
                        if (partition == null) {
                            memoryRequired += (long)(hashKey.sizeOf() + 300 * XVectorHashGroupBy.this.functionList.length);
                            partition = new XVectorBatchPartition(XVectorHashGroupBy.this.functionList);
                            this.hashMap.put(hashKey.copy(), partition);
                        }
                        this.partitionSet.set(i, partition);
                    }
                    if (memoryRequired < memoryEstimate) {
                        this.context.getMemoryManager().releaseMemory(memoryEstimate - memoryRequired);
                        this.memory -= memoryEstimate - memoryRequired;
                    }
                    for (i = 0; i < XVectorHashGroupBy.this.functionList.length; ++i) {
                        XVectorHashGroupBy.this.functionList[i].aggregate(this.context, this.partitionSet.getPartitions(), i, inputBatch);
                    }
                }
                return null;
            }

            private void processBatchToScan(FileBasedPersistedResultSet scan, GroupingKeys hashKey, XVectorRowBatch inputBatch) {
                boolean sameGroupingKeys = true;
                for (int i = 0; i < XVectorHashGroupBy.this.groupByList.length; ++i) {
                    if (inputBatch.columns[XVectorHashGroupBy.this.groupByList[i]].isRepeating) continue;
                    sameGroupingKeys = false;
                    break;
                }
                if (sameGroupingKeys) {
                    if (inputBatch.selectedInUse) {
                        hashKey.set(inputBatch, inputBatch.selected[0]);
                    } else {
                        hashKey.set(inputBatch, 0);
                    }
                    XVectorBatchPartition partition = this.hashMap.get(hashKey);
                    if (partition == null) {
                        scan.write(inputBatch);
                    } else {
                        for (int i = 0; i < XVectorHashGroupBy.this.functionList.length; ++i) {
                            XVectorHashGroupBy.this.functionList[i].aggregate(this.context, partition, i, inputBatch);
                        }
                    }
                } else {
                    int i;
                    int[] writeSelection = new int[inputBatch.size];
                    int writeSelectionSize = 0;
                    int aggregateSelectionSize = 0;
                    for (i = 0; i < inputBatch.size; ++i) {
                        int rowSelected = i;
                        if (inputBatch.selectedInUse) {
                            rowSelected = inputBatch.selected[i];
                        }
                        hashKey.set(inputBatch, rowSelected);
                        XVectorBatchPartition partition = this.hashMap.get(hashKey);
                        if (partition == null) {
                            writeSelection[writeSelectionSize] = rowSelected;
                            ++writeSelectionSize;
                            continue;
                        }
                        inputBatch.selected[aggregateSelectionSize] = rowSelected;
                        this.partitionSet.set(aggregateSelectionSize, partition);
                        ++aggregateSelectionSize;
                    }
                    if (writeSelectionSize > 0 && aggregateSelectionSize > 0) {
                        inputBatch.selectedInUse = true;
                    }
                    if (aggregateSelectionSize > 0) {
                        if (inputBatch.selectedInUse) {
                            inputBatch.size = aggregateSelectionSize;
                        }
                        for (i = 0; i < XVectorHashGroupBy.this.functionList.length; ++i) {
                            XVectorHashGroupBy.this.functionList[i].aggregate(this.context, this.partitionSet.getPartitions(), i, inputBatch);
                        }
                    }
                    if (writeSelectionSize > 0) {
                        if (inputBatch.selectedInUse) {
                            inputBatch.size = writeSelectionSize;
                            inputBatch.selected = writeSelection;
                        }
                        scan.write(inputBatch);
                    }
                }
            }

            private void logMemoryEvent() {
                XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Memory", LogLevel.TRACE);
                Runtime rt = Runtime.getRuntime();
                logger.log(String.format("VectorHashGroupBy - hash table full, reverting to scanner. Total Java Memory: %d MB, Free Calc memory: %d MB, Free Java memory: %d MB", rt.totalMemory() / 0x100000L, MemoryBookKeeper.getAvailableMemory() / 0x100000L, (rt.maxMemory() - (rt.totalMemory() - rt.freeMemory())) / 0x100000L));
            }

            @Override
            public Object getVectorizationContext() {
                return XVectorHashGroupBy.this.vContext;
            }

            private class GroupingKeys {
                private XVectorRowBatch batch;
                private int index;
                private int hashCode = 0;

                GroupingKeys() {
                }

                private GroupingKeys(XVectorRowBatch rowBatch, int rowBatchIndex, int storedHashCode) {
                    this.batch = rowBatch;
                    this.index = rowBatchIndex;
                    this.hashCode = storedHashCode;
                }

                public GroupingKeys copy() {
                    return new GroupingKeys(this.batch, this.index, this.hashCode);
                }

                public void set(XVectorRowBatch rowBatch, int rowBatchIndex) {
                    this.batch = rowBatch;
                    this.index = rowBatchIndex;
                    this.hashCode = this.batch.hashCode(this.index, XVectorHashGroupBy.this.groupByList, true);
                }

                public int hashCode() {
                    return this.hashCode;
                }

                public int sizeOf() {
                    int size = ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.OBJECTSIZE);
                    return size;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (!(obj instanceof GroupingKeys)) {
                        return false;
                    }
                    GroupingKeys other = (GroupingKeys)obj;
                    if (this.hashCode != other.hashCode) {
                        return false;
                    }
                    try {
                        for (int i = 0; i < XVectorHashGroupBy.this.groupByList.length; ++i) {
                            if (this.batch.equals(other.batch, this.index, other.index, XVectorHashGroupBy.this.groupByList)) continue;
                            return false;
                        }
                        return true;
                    }
                    catch (XQERuntimeException e) {
                        return false;
                    }
                }
            }
        }
    }
}

