/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.Join;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.MemoryBookKeeper;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.util.FileBasedPersistedResultSet;
import com.cognos.xqe.runtree.relational.util.VectorizedHashKeysSet;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorJoin;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorTabularIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IReleasable;
import java.util.HashSet;
import java.util.Set;

public class XVectorHashSemiJoin
extends XVectorJoin {
    private static final long serialVersionUID = 1L;

    @Override
    protected IValue executeImpl(XDataContext context) throws XQERuntimeException {
        return new TabularHybridResultSet(context, new XVectorHashSemiJoinResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501184;
    }

    protected class XVectorHashSemiJoinResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private IHybridResultSet[] iResultSets;

        public XVectorHashSemiJoinResultSet(XDataContext theContext) {
            super(theContext, XVectorHashSemiJoin.this.getId());
            try {
                this.iResultSets = new IHybridResultSet[2];
                for (int i = 0; i < 2; ++i) {
                    this.iResultSets[i] = (IHybridResultSet)((IExecutable)((Object)XVectorHashSemiJoin.this.getChild(i))).execute(this.getDataContext());
                }
                super.setTabularRowsetInfo(this.iResultSets[0].getTabularRowsetInfo());
            }
            catch (RuntimeException e) {
                this.release();
                throw e;
            }
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XVectorHashSemiJoinIterator(this.getDataContext());
        }

        @Override
        public void releaseImpl() {
            if (this.iResultSets != null) {
                XVectorHashSemiJoinResultSet.releaseNonNullReleasables((IReleasable[])this.iResultSets);
                this.iResultSets = null;
                this.rowsetInfo = null;
            }
        }

        protected class XVectorHashSemiJoinIterator
        extends XVectorTabularIterator {
            protected static final int BUILD_INDEX = 1;
            protected static final int PROBE_INDEX = 0;
            protected ITabularIterator probeIterator;
            protected XVectorRowBatch probeBatch;
            protected XVectorRowBatch result;
            protected IRowsetInfo probeRowsetInfo;
            protected FileBasedPersistedResultSet probeScan;
            protected int probeScanCurrentBatchSize;
            protected VectorBuildTable buildTable;

            protected XVectorHashSemiJoinIterator(XDataContext context) {
                super(context, XVectorHashSemiJoin.this.getId(), XVectorHashSemiJoinResultSet.this.rowsetInfo);
                this.probeRowsetInfo = null;
                this.probeScan = null;
                this.probeScanCurrentBatchSize = 0;
                this.buildTable = null;
                try {
                    this.startTimer();
                    this.result = XVectorRowBatchUtil.createRowBatch(XVectorHashSemiJoin.this.vContext, XVectorHashSemiJoinResultSet.this.rowsetInfo, context.getLocalCollator());
                    this.probeRowsetInfo = XVectorHashSemiJoinResultSet.this.iResultSets[0].getTabularRowsetInfo();
                    this.probeIterator = XVectorHashSemiJoinResultSet.this.iResultSets[0].getTabularIterator();
                    this.buildTable = new VectorBuildTable();
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextBatch() {
                this.result.reset();
                while (!(this.result.size >= this.result.maxBatchSize || this.probeBatch != null && this.probeBatch.eod)) {
                    this.getNextProbeRow();
                    if (this.probeBatch.eod) break;
                    if (!this.buildTable.matchProbeRow()) {
                        if (this.buildTable.lastPartition()) continue;
                        this.writeProbeRow();
                        continue;
                    }
                    int index = this.probeBatch.index;
                    if (this.probeBatch.selectedInUse) {
                        index = this.probeBatch.selected[index];
                    }
                    XVectorRowBatchUtil.copyRow(index, this.probeBatch, this.result.size, this.result, true);
                    ++this.result.size;
                }
                if (this.probeBatch.eod && this.result.size == 0) {
                    this.result.eod = true;
                }
                return this.result;
            }

            protected void writeProbeRow() {
                if (this.probeScan == null) {
                    this.probeScan = new FileBasedPersistedResultSet(this.probeRowsetInfo.getDataType(), this.context);
                }
                if (this.probeScanCurrentBatchSize == 0) {
                    this.probeBatch.selectedInUse = true;
                }
                this.probeBatch.selected[this.probeScanCurrentBatchSize] = this.probeBatch.index;
                ++this.probeScanCurrentBatchSize;
            }

            protected void getNextProbeRow() {
                while (true) {
                    if (this.probeBatch != null && this.probeBatch.index < this.probeBatch.size - 1) {
                        ++this.probeBatch.index;
                        break;
                    }
                    if (this.probeScan != null && this.probeScanCurrentBatchSize > 0) {
                        this.probeBatch.size = this.probeScanCurrentBatchSize;
                        this.probeScan.write(this.probeBatch);
                        this.probeScanCurrentBatchSize = 0;
                    }
                    this.probeBatch = (XVectorRowBatch)this.probeIterator.nextBatch();
                    this.probeBatch.index = 0;
                    if (!this.probeBatch.eod) break;
                    this.probeIterator.release();
                    this.probeIterator = null;
                    if (this.probeScan == null) break;
                    this.probeIterator = this.probeScan.getVectorizedIterator(this.probeRowsetInfo, XVectorHashSemiJoin.this.vContext);
                    this.probeScan = null;
                    this.probeBatch = null;
                    if (this.buildTable.lastPartition()) {
                        throw new RuntimeException("Incorrect state - build there is no more build partitions, but the probe table is saved");
                    }
                    this.buildTable.loadNextPartition();
                }
            }

            @Override
            public long getIndex() {
                return this.nRows;
            }

            @Override
            public void release() {
                this.buildTable.release();
                try {
                    if (this.probeIterator != null) {
                        this.probeIterator.release();
                    }
                }
                catch (Exception ex) {
                    mErrorLogger.log(ex);
                }
                finally {
                    this.probeIterator = null;
                }
                if (this.probeScan != null) {
                    this.probeScan.release();
                    this.probeScan = null;
                }
            }

            @Override
            public Object getVectorizationContext() {
                return XVectorHashSemiJoin.this.vContext;
            }

            protected class VectorBuildTable {
                private static final String MEMORY_MESSAGE_FORMAT = "Total Java Memory: %d MB, Free Calc memory: %d MB, Free Java memory: %d MB";
                private Set<VectorizedHashKeysSet> hashSet = null;
                private ITabularIterator buildIterator = null;
                private XVectorRowBatch buildBatch;
                long memory = 0L;
                int[] probeJoinColumns = null;
                private boolean useFastHash = true;
                private IRowsetInfo buildRowsetInfo = null;
                private VectorizedHashKeysSet probeKeys = null;
                private boolean first = true;
                private boolean joinThroughCompatibleDataType = true;

                VectorBuildTable() {
                    int i;
                    int nJoins = XVectorHashSemiJoin.this.joins.size();
                    this.probeJoinColumns = new int[nJoins];
                    for (i = 0; i < nJoins; ++i) {
                        Join join = (Join)XVectorHashSemiJoin.this.joins.get(i);
                        this.probeJoinColumns[i] = join.getLeftJoin().getColumnNo();
                    }
                    this.buildRowsetInfo = XVectorHashSemiJoinResultSet.this.iResultSets[1].getTabularRowsetInfo();
                    for (i = 0; i < nJoins; ++i) {
                        IDataType dt1 = this.buildRowsetInfo.getColumnInfo(i).getDataType();
                        IDataType dt2 = XVectorHashSemiJoinIterator.this.probeRowsetInfo.getColumnInfo(this.probeJoinColumns[i]).getDataType();
                        if (this.useFastHash && dt1.getCCLTypeCode() != dt2.getCCLTypeCode()) {
                            this.useFastHash = false;
                        }
                        if (!this.joinThroughCompatibleDataType || DataTypeComparator.areCompatibleDataTypes(dt1, dt2)) continue;
                        this.joinThroughCompatibleDataType = false;
                    }
                    this.buildIterator = XVectorHashSemiJoinResultSet.this.iResultSets[1].getTabularIterator();
                    this.hashSet = new HashSet<VectorizedHashKeysSet>();
                    this.probeKeys = new VectorizedHashKeysSet(this.probeJoinColumns, this.useFastHash, !this.joinThroughCompatibleDataType);
                }

                public boolean matchProbeRow() {
                    if (this.first) {
                        this.first = false;
                        this.loadNextPartition();
                    }
                    int index = XVectorHashSemiJoinIterator.this.probeBatch.index;
                    if (XVectorHashSemiJoinIterator.this.probeBatch.selectedInUse) {
                        index = XVectorHashSemiJoinIterator.this.probeBatch.selected[index];
                    }
                    for (int i = 0; i < this.probeJoinColumns.length; ++i) {
                        if (!XVectorHashSemiJoinIterator.this.probeBatch.columns[this.probeJoinColumns[i]].isNull[index]) continue;
                        return false;
                    }
                    this.probeKeys.set(XVectorHashSemiJoinIterator.this.probeBatch, index);
                    return this.hashSet.contains(this.probeKeys);
                }

                public boolean lastPartition() {
                    return this.buildIterator == null;
                }

                private void loadNextPartition() {
                    FileBasedPersistedResultSet scan = null;
                    this.hashSet.clear();
                    if (this.memory > 0L) {
                        XVectorHashSemiJoinIterator.this.context.getMemoryManager().releaseMemory(this.memory);
                    }
                    int[] buildColumns = new int[XVectorHashSemiJoin.this.joins.size()];
                    for (int i = 0; i < buildColumns.length; ++i) {
                        buildColumns[i] = i;
                    }
                    VectorizedHashKeysSet currentHashKey = new VectorizedHashKeysSet(buildColumns, this.useFastHash, !this.joinThroughCompatibleDataType);
                    XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Memory", LogLevel.TRACE);
                    Runtime rt = Runtime.getRuntime();
                    logger.log(String.format("Hash semi Join - start building next partition. Total Java Memory: %d MB, Free Calc memory: %d MB, Free Java memory: %d MB", rt.totalMemory() / 0x100000L, MemoryBookKeeper.getAvailableMemory() / 0x100000L, (rt.maxMemory() - (rt.totalMemory() - rt.freeMemory())) / 0x100000L));
                    while (true) {
                        boolean forced;
                        long batchSize;
                        try {
                            this.buildBatch = (XVectorRowBatch)this.buildIterator.nextBatch();
                        }
                        catch (RuntimeException e) {
                            if (scan != null) {
                                scan.release();
                            }
                            this.release();
                            throw e;
                        }
                        if (this.buildBatch.eod) {
                            XVectorContext vc = XVectorHashSemiJoin.this.vContext;
                            if (this.buildIterator instanceof XTabularIterator && null != ((XTabularIterator)this.buildIterator).getVectorizationContext()) {
                                vc = (XVectorContext)((XTabularIterator)this.buildIterator).getVectorizationContext();
                            }
                            this.buildIterator.release();
                            this.buildIterator = null;
                            if (scan == null) break;
                            this.buildIterator = scan.getVectorizedIterator(this.buildRowsetInfo, vc);
                            scan = null;
                            break;
                        }
                        long memRequired = batchSize = (long)this.buildBatch.sizeOf();
                        long memEstimate = batchSize;
                        memEstimate += (long)(currentHashKey.sizeOf() * this.buildBatch.size);
                        boolean bl = forced = this.hashSet.size() == 0;
                        if (scan != null) {
                            scan.write(this.buildBatch);
                        } else if (!XVectorHashSemiJoinIterator.this.context.getMemoryManager().allocateMemory(memEstimate, forced)) {
                            logger.log(String.format("Hash Semi Join - partition is full, reverting to scanner. Total Java Memory: %d MB, Free Calc memory: %d MB, Free Java memory: %d MB", rt.totalMemory() / 0x100000L, MemoryBookKeeper.getAvailableMemory() / 0x100000L, (rt.maxMemory() - (rt.totalMemory() - rt.freeMemory())) / 0x100000L));
                            scan = new FileBasedPersistedResultSet(this.buildRowsetInfo.getDataType(), XVectorHashSemiJoinIterator.this.context);
                            scan.write(this.buildBatch);
                        } else {
                            this.buildBatch = this.buildBatch.copy();
                            this.memory += memRequired;
                        }
                        for (int j = 0; j < this.buildBatch.size; ++j) {
                            int index = j;
                            if (this.buildBatch.selectedInUse) {
                                index = this.buildBatch.selected[j];
                            }
                            boolean ignore = false;
                            for (int i = 0; i < this.buildBatch.columns.length; ++i) {
                                if (!this.buildBatch.columns[i].isNull[index]) continue;
                                ignore = true;
                                break;
                            }
                            if (ignore) continue;
                            currentHashKey.set(this.buildBatch, index);
                            if (this.hashSet.contains(currentHashKey) || scan != null) continue;
                            this.hashSet.add(currentHashKey.copy());
                            memRequired += (long)currentHashKey.sizeOf();
                        }
                        long memoryToRelease = memEstimate - memRequired;
                        if (memoryToRelease <= 0L) continue;
                        XVectorHashSemiJoinIterator.this.context.getMemoryManager().releaseMemory(memoryToRelease);
                        this.memory -= memoryToRelease;
                    }
                    logger.log(String.format("Hash Semi Join - partition is  built. Total Java Memory: %d MB, Free Calc memory: %d MB, Free Java memory: %d MB", rt.totalMemory() / 0x100000L, MemoryBookKeeper.getAvailableMemory() / 0x100000L, (rt.maxMemory() - (rt.totalMemory() - rt.freeMemory())) / 0x100000L));
                }

                void release() {
                    try {
                        if (this.buildIterator != null) {
                            this.buildIterator.release();
                        }
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.buildIterator = null;
                    }
                    this.hashSet.clear();
                    if (this.memory > 0L) {
                        XVectorHashSemiJoinIterator.this.context.getMemoryManager().releaseMemory(this.memory);
                    }
                }
            }
        }
    }
}

