/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.XSetOperator;
import com.cognos.xqe.runtree.relational.util.FileBasedPersistedResultSet;
import com.cognos.xqe.runtree.relational.util.VectorizedHashKeysSet;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorTabularIterator;
import gnu.trove.map.hash.THashMap;
import java.util.Map;

public class XVectorIntersect
extends XSetOperator {
    private static final long serialVersionUID = 1L;

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XVectorIntersectResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501192;
    }

    protected class XVectorIntersectResultSet
    extends XSetOperator.ResultSet
    implements ITabularResultSet {
        public XVectorIntersectResultSet(XDataContext theContext) {
            super(XVectorIntersect.this, theContext);
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XVectorIntersectIteratorOther(this.getDataContext());
        }

        protected class XVectorIntersectIteratorOther
        extends XVectorTabularIterator {
            private static final int BUILD_INDEX = 0;
            private static final int PROBE_INDEX = 1;
            protected ITabularIterator probeIterator;
            protected XVectorRowBatch probeBatch;
            protected XVectorRowBatch result;
            protected IRowsetInfo probeRowsetInfo;
            protected FileBasedPersistedResultSet probeScan;
            protected int probeScanCurrentBatchSize;
            protected VectorBuildTable buildTable;
            protected int index;

            protected XVectorIntersectIteratorOther(XDataContext context) {
                super(context, XVectorIntersect.this.getId(), XVectorIntersectResultSet.this.rowsetInfo);
                this.probeRowsetInfo = null;
                this.probeScan = null;
                this.probeScanCurrentBatchSize = 0;
                this.buildTable = null;
                this.index = -1;
                try {
                    this.startTimer();
                    this.result = XVectorRowBatchUtil.createRowBatch(XVectorIntersect.this.vContext, XVectorIntersectResultSet.this.rowsetInfo, context.getLocalCollator());
                    this.initProbeIteratorAndBuildTable();
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            protected void initProbeIteratorAndBuildTable() {
                this.probeRowsetInfo = XVectorIntersectResultSet.this.iResultSets[1].getTabularRowsetInfo();
                this.probeIterator = XVectorIntersectResultSet.this.iResultSets[1].getTabularIterator();
                this.buildTable = new VectorBuildTable(0);
            }

            @Override
            public Object nextBatch() {
                this.result.reset();
                while (!(this.result.size >= this.result.maxBatchSize || this.probeBatch != null && this.probeBatch.eod)) {
                    this.getNextProbeRow();
                    if (this.probeBatch.eod) break;
                    int match = this.buildTable.matchAndDecrement();
                    if (match == 0) continue;
                    if (match == 1) {
                        XVectorRowBatchUtil.copyRow(this.probeBatch.index, this.probeBatch, this.result.size, this.result, true);
                        ++this.result.size;
                    }
                    if (this.buildTable.lastPartition()) continue;
                    this.writeProbeRow();
                }
                if (this.probeBatch.eod && this.result.size == 0) {
                    this.result.eod = true;
                }
                return this.result;
            }

            protected void writeProbeRow() {
                if (this.probeScan == null) {
                    this.probeScan = new FileBasedPersistedResultSet(this.probeRowsetInfo.getDataType(), this.context);
                }
                if (this.probeScanCurrentBatchSize == 0) {
                    this.probeBatch.selectedInUse = true;
                }
                this.probeBatch.selected[this.probeScanCurrentBatchSize] = this.probeBatch.index;
                ++this.probeScanCurrentBatchSize;
            }

            protected void getNextProbeRow() {
                block6: {
                    while (true) {
                        if (this.probeBatch != null && this.index < this.probeBatch.size - 1) {
                            ++this.index;
                            this.probeBatch.index = this.probeBatch.selectedInUse ? this.probeBatch.selected[this.index] : this.index;
                        } else {
                            if (this.probeScan != null && this.probeScanCurrentBatchSize > 0) {
                                this.probeBatch.size = this.probeScanCurrentBatchSize;
                                this.probeScan.write(this.probeBatch);
                                this.probeScanCurrentBatchSize = 0;
                            }
                            this.probeBatch = (XVectorRowBatch)this.probeIterator.nextBatch();
                            if (!this.probeBatch.eod) break;
                            this.probeIterator.release();
                            this.probeIterator = null;
                            if (this.probeScan != null) {
                                this.probeIterator = this.probeScan.getVectorizedIterator(this.probeRowsetInfo, XVectorIntersect.this.vContext);
                                this.probeScan = null;
                                this.probeBatch = null;
                                if (this.buildTable.lastPartition()) {
                                    throw new RuntimeException("Incorrect state - build there is no more build partitions, but the probe table is saved");
                                }
                                this.buildTable.loadNextPartition();
                                continue;
                            }
                        }
                        break block6;
                        break;
                    }
                    this.index = 0;
                    this.probeBatch.index = this.probeBatch.selectedInUse ? this.probeBatch.selected[this.index] : this.index;
                }
            }

            @Override
            public long getIndex() {
                return this.nRows;
            }

            @Override
            public void release() {
                this.buildTable.release();
                try {
                    if (this.probeIterator != null) {
                        this.probeIterator.release();
                    }
                }
                catch (Exception ex) {
                    mErrorLogger.log(ex);
                }
                finally {
                    this.probeIterator = null;
                }
                if (this.probeScan != null) {
                    this.probeScan.release();
                    this.probeScan = null;
                }
            }

            @Override
            public Object getVectorizationContext() {
                return XVectorIntersect.this.vContext;
            }

            class VectorBuildTable {
                private Map<VectorizedHashKeysSet, long[]> hashMap = null;
                private ITabularIterator buildIterator = null;
                private XVectorRowBatch buildBatch;
                long memory = 0L;
                private boolean useFastHash = true;
                private IRowsetInfo buildRowsetInfo = null;
                private VectorizedHashKeysSet probeKeys = null;
                private boolean first = true;

                VectorBuildTable(int buildIndex) {
                    this.buildRowsetInfo = XVectorIntersectResultSet.this.iResultSets[buildIndex].getTabularRowsetInfo();
                    this.buildIterator = XVectorIntersectResultSet.this.iResultSets[buildIndex].getTabularIterator();
                    for (int i = 0; i < this.buildRowsetInfo.getNumColumns(); ++i) {
                        if (this.buildRowsetInfo.getColumnInfo(i).getDataType().getCCLTypeCode() == XVectorIntersectIteratorOther.this.probeRowsetInfo.getColumnInfo(i).getDataType().getCCLTypeCode()) continue;
                        this.useFastHash = false;
                        break;
                    }
                    this.hashMap = new THashMap();
                    int[] probeColumns = new int[XVectorIntersectIteratorOther.this.probeRowsetInfo.getNumColumns()];
                    for (int i = 0; i < probeColumns.length; ++i) {
                        probeColumns[i] = i;
                    }
                    this.probeKeys = new VectorizedHashKeysSet(probeColumns, this.useFastHash, false);
                }

                public int matchAndDecrement() {
                    if (this.first) {
                        this.first = false;
                        this.loadNextPartition();
                    }
                    this.probeKeys.set(XVectorIntersectIteratorOther.this.probeBatch, XVectorIntersectIteratorOther.this.probeBatch.index);
                    long[] count = this.hashMap.get(this.probeKeys);
                    if (count == null) {
                        return -1;
                    }
                    if (count[0] == 0L) {
                        return 0;
                    }
                    count[0] = XVectorIntersect.this.all ? count[0] - 1L : 0L;
                    return 1;
                }

                public boolean lastPartition() {
                    return this.buildIterator == null;
                }

                private void loadNextPartition() {
                    FileBasedPersistedResultSet scan = null;
                    this.hashMap.clear();
                    if (this.memory > 0L) {
                        XVectorIntersectIteratorOther.this.context.getMemoryManager().releaseMemory(this.memory);
                    }
                    int[] buildColumns = new int[this.buildRowsetInfo.getNumColumns()];
                    for (int i = 0; i < buildColumns.length; ++i) {
                        buildColumns[i] = i;
                    }
                    VectorizedHashKeysSet currentHashKey = new VectorizedHashKeysSet(buildColumns, this.useFastHash, false);
                    while (true) {
                        boolean forced;
                        long batchSize;
                        try {
                            this.buildBatch = (XVectorRowBatch)this.buildIterator.nextBatch();
                        }
                        catch (RuntimeException e) {
                            if (scan != null) {
                                scan.release();
                            }
                            this.release();
                            throw e;
                        }
                        if (this.buildBatch.eod) {
                            XVectorContext vc = XVectorIntersect.this.vContext;
                            if (this.buildIterator instanceof XTabularIterator && null != ((XTabularIterator)this.buildIterator).getVectorizationContext()) {
                                vc = (XVectorContext)((XTabularIterator)this.buildIterator).getVectorizationContext();
                            }
                            this.buildIterator.release();
                            this.buildIterator = null;
                            if (scan == null) break;
                            this.buildIterator = scan.getVectorizedIterator(this.buildRowsetInfo, vc);
                            scan = null;
                            break;
                        }
                        long memRequired = batchSize = (long)this.buildBatch.sizeOf();
                        long memEstimate = batchSize;
                        memEstimate += (long)(currentHashKey.sizeOf() * this.buildBatch.size + ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.ARRAYLIST) * this.buildBatch.size);
                        boolean bl = forced = this.hashMap.size() == 0;
                        if (scan != null) {
                            scan.write(this.buildBatch);
                        } else if (!XVectorIntersectIteratorOther.this.context.getMemoryManager().allocateMemory(memEstimate, forced)) {
                            scan = new FileBasedPersistedResultSet(this.buildRowsetInfo.getDataType(), XVectorIntersectIteratorOther.this.context);
                            scan.write(this.buildBatch);
                        } else {
                            this.buildBatch = this.buildBatch.copy();
                            this.memory += memRequired;
                        }
                        for (int j = 0; j < this.buildBatch.size; ++j) {
                            int srcIndex = j;
                            if (this.buildBatch.selectedInUse) {
                                srcIndex = this.buildBatch.selected[j];
                            }
                            currentHashKey.set(this.buildBatch, srcIndex);
                            long[] count = this.hashMap.get(currentHashKey);
                            if (count != null) {
                                count[0] = count[0] + 1L;
                                continue;
                            }
                            if (scan != null) continue;
                            count = new long[]{1L};
                            this.hashMap.put(currentHashKey.copy(), count);
                            memRequired += (long)(currentHashKey.sizeOf() + ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.ARRAYLIST));
                        }
                        long memoryToRelease = memEstimate - memRequired;
                        if (memoryToRelease <= 0L) continue;
                        XVectorIntersectIteratorOther.this.context.getMemoryManager().releaseMemory(memoryToRelease);
                        this.memory -= memoryToRelease;
                    }
                }

                void release() {
                    try {
                        if (this.buildIterator != null) {
                            this.buildIterator.release();
                        }
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.buildIterator = null;
                    }
                    this.hashMap.clear();
                    if (this.memory > 0L) {
                        XVectorIntersectIteratorOther.this.context.getMemoryManager().releaseMemory(this.memory);
                    }
                }
            }
        }
    }
}

