/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.XJoin;
import com.cognos.xqe.runtree.relational.vectorization.XVectorJoin;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorTabularIterator;
import org.dom4j.Element;

public class XVectorNestedLoopsJoin
extends XVectorJoin {
    private static final long serialVersionUID = 1L;

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XVectorNestedLoopsJoinResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501181;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        String jType = inputNode.attributeValue("joinType");
        this.joinType = jType == null || jType.equals(XJoin.JoinType.INNER.getDescriptor()) ? XJoin.JoinType.INNER : XJoin.JoinType.LEFT_OUTER;
        super.capture(env, inputNode);
    }

    private final class XVectorNestedLoopsJoinResultSet
    extends XVectorJoin.ResultSet
    implements ITabularResultSet {
        XVectorNestedLoopsJoinResultSet(XDataContext context) {
            super(context, XVectorNestedLoopsJoin.this.getNumberChildren() - 1, XVectorNestedLoopsJoin.this.getId());
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XVectorNestedLoopsJoinIterator(this.getDataContext());
        }

        private final class XVectorNestedLoopsJoinIterator
        extends XVectorTabularIterator {
            private ITabularIterator[] tabIt;
            private XVectorRowBatch[] inputBatches;
            private int current;

            private XVectorNestedLoopsJoinIterator(XDataContext context) {
                super(context, XVectorNestedLoopsJoin.this.getId(), XVectorNestedLoopsJoinResultSet.this.rowsetInfo);
                this.current = 0;
                try {
                    this.startTimer();
                    this.tabIt = new XTabularIterator[2];
                    this.inputBatches = new XVectorRowBatch[2];
                    this.tabIt[0] = (XTabularIterator)XVectorNestedLoopsJoinResultSet.this.iResultSets[0].getTabularIterator();
                    this.batch = XVectorRowBatchUtil.createRowBatch(XVectorNestedLoopsJoin.this.vContext, XVectorNestedLoopsJoinResultSet.this.rowsetInfo, context.getLocalCollator());
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextBatch() {
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                this.batch.reset();
                while (this.current >= 0) {
                    if (this.batch.size == this.batch.maxBatchSize) {
                        XVectorRowBatch rowBatch = this.inputBatches[0];
                        if (rowBatch.index != 0) break;
                        for (int j = 0; j < rowBatch.columns.length; ++j) {
                            this.batch.columns[j].isRepeating = true;
                        }
                        break;
                    }
                    XVectorRowBatch cBatch = this.getCurrentBatch();
                    if (cBatch.eod || ++cBatch.index == cBatch.size) {
                        this.inputBatches[this.current] = null;
                        if (!cBatch.eod) continue;
                        this.tabIt[this.current].release();
                        this.tabIt[this.current] = null;
                        --this.current;
                        continue;
                    }
                    if (this.current == 1) {
                        XVectorNestedLoopsJoinResultSet.this.combine(this.batch, this.inputBatches);
                        continue;
                    }
                    ++this.current;
                }
                if (this.batch.size == 0) {
                    this.batch.eod = true;
                } else {
                    XVectorNestedLoopsJoinResultSet.this.predicate.evaluate(this.context, this.batch);
                }
                return this.batch;
            }

            private XVectorRowBatch getCurrentBatch() {
                if (this.inputBatches[this.current] == null) {
                    if (this.tabIt[this.current] == null) {
                        this.tabIt[this.current] = (XTabularIterator)XVectorNestedLoopsJoinResultSet.this.iResultSets[this.current].getTabularIterator();
                    }
                    this.inputBatches[this.current] = (XVectorRowBatch)this.tabIt[this.current].nextBatch();
                    this.inputBatches[this.current].index = -1;
                }
                return this.inputBatches[this.current];
            }

            @Override
            public long getIndex() {
                return this.nRows;
            }

            @Override
            public void release() {
                if (this.tabIt != null) {
                    for (int i = 0; i < this.tabIt.length; ++i) {
                        if (this.tabIt[i] == null) continue;
                        try {
                            this.tabIt[i].release();
                            continue;
                        }
                        catch (Exception ex) {
                            mErrorLogger.log(ex);
                            continue;
                        }
                        finally {
                            this.tabIt[i] = null;
                        }
                    }
                    this.tabIt = null;
                }
                this.inputBatches = null;
                super.release();
            }

            @Override
            public Object getVectorizationContext() {
                return XVectorNestedLoopsJoin.this.vContext;
            }
        }
    }
}

