/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.resultset.interfaces.IColumnInfo;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.runtree.relational.vectorization.BytesColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.DecimalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.DoubleColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.IntervalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.NFDStringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.VectorType;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.ibm.icu.text.Collator;
import java.util.Map;

public class XVectorRowBatchUtil {
    public static XVectorRowBatch createRowBatch(XVectorContext vContext, IRowsetInfo rowsetInfo, Collator c) {
        if (vContext == null) {
            return XVectorRowBatchUtil.createRowBatch(rowsetInfo, c);
        }
        return XVectorRowBatchUtil.createRowBatch(vContext, rowsetInfo, c, false);
    }

    public static XVectorRowBatch createRowBatch(XVectorContext vContext, IRowsetInfo rowsetInfo, Collator c, boolean allocateScratchColumnsOnly) {
        if (vContext == null) {
            return XVectorRowBatchUtil.createRowBatch(rowsetInfo, c);
        }
        Map<Integer, IDataType> scratchColumns = vContext.getScratchColumnTypeMap();
        int nColumns = rowsetInfo.getNumColumns() + scratchColumns.size();
        XVectorRowBatch batch = new XVectorRowBatch(nColumns, scratchColumns.size());
        int i = 0;
        if (!allocateScratchColumnsOnly) {
            for (IColumnInfo columnInfo : rowsetInfo.getColumnInfos()) {
                XVectorRowBatchUtil.allocateVector(batch, i++, columnInfo.getDataType(), columnInfo.isNormalized(), columnInfo.isSorted(), c, batch.maxBatchSize);
            }
        }
        for (Map.Entry entry : scratchColumns.entrySet()) {
            XVectorRowBatchUtil.allocateVector(batch, (Integer)entry.getKey(), (IDataType)entry.getValue(), false, false, c, batch.maxBatchSize);
        }
        return batch;
    }

    public static XVectorRowBatch createRowBatch(IRowsetInfo rowsetInfo, Collator c) {
        XVectorRowBatch batch = new XVectorRowBatch(rowsetInfo.getNumColumns());
        int i = 0;
        for (IColumnInfo columnInfo : rowsetInfo.getColumnInfos()) {
            XVectorRowBatchUtil.allocateVector(batch, i++, columnInfo.getDataType(), columnInfo.isNormalized(), columnInfo.isSorted(), c, batch.maxBatchSize);
        }
        return batch;
    }

    public static XVectorRowBatch createRowBatch(IRowsetInfo rowsetInfo, Collator c, int maxBatchSize) {
        XVectorRowBatch batch = new XVectorRowBatch(rowsetInfo.getNumColumns());
        int i = 0;
        for (IColumnInfo columnInfo : rowsetInfo.getColumnInfos()) {
            XVectorRowBatchUtil.allocateVector(batch, i++, columnInfo.getDataType(), columnInfo.isNormalized(), columnInfo.isSorted(), c, maxBatchSize);
        }
        return batch;
    }

    public static void expandRowBatch(XVectorRowBatch batch, int size) {
        batch.maxBatchSize += size;
        for (ColumnVector columnVector : batch.columns) {
            columnVector.expand(size);
        }
    }

    private static void allocateVector(XVectorRowBatch batch, int index, IDataType dataType, boolean isNormalized, boolean isSorted, Collator c, int maxVectorSize) {
        ColumnVector columnVector;
        VectorType type = XVectorRowBatchUtil.getVectorTypeFromDataType(dataType);
        switch (type) {
            case BYTES: {
                columnVector = new BytesColumnVector(dataType, isSorted, maxVectorSize);
                break;
            }
            case LONG: {
                columnVector = new LongColumnVector(dataType, isSorted, maxVectorSize);
                break;
            }
            case DOUBLE: {
                columnVector = new DoubleColumnVector(dataType, isSorted, maxVectorSize);
                break;
            }
            case STRING: {
                if (isNormalized) {
                    columnVector = new NFDStringColumnVector(dataType, isSorted, maxVectorSize, c);
                    break;
                }
                columnVector = new StringColumnVector(dataType, isSorted, maxVectorSize, c);
                break;
            }
            case DECIMAL: {
                columnVector = new DecimalColumnVector(dataType, isSorted, maxVectorSize);
                break;
            }
            case TIMESTAMP: {
                columnVector = new TimestampColumnVector(dataType, isSorted, maxVectorSize);
                break;
            }
            case INTERVAL: {
                columnVector = new IntervalColumnVector(dataType, isSorted, maxVectorSize);
                break;
            }
            default: {
                throw new IllegalArgumentException("Vector type not supported.");
            }
        }
        batch.columns[index] = columnVector;
    }

    public static VectorType getVectorTypeFromDataType(IDataType dataType) {
        if (dataType.isBinary()) {
            return VectorType.BYTES;
        }
        if (dataType.isDate() || dataType.isBoolean()) {
            return VectorType.LONG;
        }
        if (dataType.isInteger()) {
            if (dataType.getScale() == 0) {
                return VectorType.LONG;
            }
            return VectorType.DECIMAL;
        }
        if (dataType.isApproximateNumeric()) {
            return VectorType.DOUBLE;
        }
        if (dataType.isTextType() || dataType.isClob()) {
            return VectorType.STRING;
        }
        if (dataType.isDecimal()) {
            return VectorType.DECIMAL;
        }
        if (dataType.isTime() || dataType.isTimestamp()) {
            return VectorType.TIMESTAMP;
        }
        if (dataType.isInterval()) {
            return VectorType.INTERVAL;
        }
        if (dataType.isNullType()) {
            return VectorType.LONG;
        }
        return VectorType.BYTES;
    }

    public static XVectorRowBatch copyRowBatchStructure(XVectorRowBatch originalBatch, int maxSize) {
        XVectorRowBatch batch = new XVectorRowBatch(originalBatch.columns.length, originalBatch.nScratchColumns, maxSize);
        for (int i = 0; i < originalBatch.columns.length; ++i) {
            ColumnVector columnVector = originalBatch.columns[i];
            XVectorRowBatchUtil.allocateVector(batch, i, columnVector.getDataType(), columnVector.isNormalized(), columnVector.isSorted(), columnVector.getCollator(), batch.maxBatchSize);
            batch.columns[i].isRepeating = true;
        }
        return batch;
    }

    public static void copyRow(int sourceIndex, XVectorRowBatch sourceBatch, int targetIndex, XVectorRowBatch targetBatch, boolean addRow) {
        int nColumns = sourceBatch.columns.length - sourceBatch.nScratchColumns;
        for (int i = 0; i < nColumns; ++i) {
            sourceBatch.columns[i].copyValue(sourceIndex, targetIndex, targetBatch.columns[i], addRow);
        }
    }
}

