/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.RequestCanceledException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.caching.ForwardOnlyColumnarCache;
import com.cognos.xqe.resultsets.caching.ForwardOnlyTabularCache;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorTabularIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XVectorStore
extends XTabularResultSet {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_FETCHALL = "fetchAll";
    protected ForwardOnlyTabularCache cache;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    protected AtomicInteger refCount = new AtomicInteger(0);
    private ITabularResultSet iResultSet;
    private boolean fetchAll;
    protected static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XVectorStoreResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501186;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.fetchAll = Boolean.valueOf(inputNode.attributeValue(ATTRIBUTE_FETCHALL));
        List elements = inputNode.elements();
        Element child = (Element)elements.get(0);
        this.vContext = new XVectorContext();
        this.vContext.capture(env, child);
        this.capture(env, inputNode, elements.size() - 1);
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        super.restoreAttributeProperty(ctx, att, inputNode);
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        super.restoreElementProperty(ctx, node, inputNode);
    }

    private final class XVectorStoreResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private static final int MAX_PAGES_DEFAULT = 6;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        XVectorStoreResultSet(XDataContext context) {
            super(context, XVectorStore.this.getId());
            try {
                XVectorStore.this.lock.writeLock().lockInterruptibly();
                try {
                    if (XVectorStore.this.cache == null) {
                        XVectorStore.this.iResultSet = (ITabularResultSet)((IExecutable)((Object)XVectorStore.this.getChild(0))).execute(context);
                        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
                        int nPages = config.getIntProperty("general.queryReuse.data[@maxMemory]", 6);
                        XVectorStore.this.cache = new ForwardOnlyColumnarCache(context, XVectorStore.this.iResultSet, XVectorStore.this.getId(), nPages);
                        if (XVectorStore.this.fetchAll) {
                            XVectorRowBatch batch;
                            ITabularIterator tabIt = XVectorStore.this.cache.getTabularIterator(context, XVectorStore.this.vContext);
                            do {
                                batch = (XVectorRowBatch)tabIt.nextBatch();
                            } while (!batch.eod);
                            tabIt.release();
                        }
                    }
                    IRowsetInfo rowsetInfo = XVectorStore.this.iResultSet.getTabularRowsetInfo();
                    XVectorStore.this.refCount.incrementAndGet();
                    super.setTabularRowsetInfo(rowsetInfo);
                }
                finally {
                    XVectorStore.this.lock.writeLock().unlock();
                }
            }
            catch (InterruptedException e) {
                throw new RequestCanceledException();
            }
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XVectorStoreIterator(this.getDataContext());
        }

        @Override
        public void releaseImpl() {
            if (XVectorStore.this.iResultSet != null) {
                XVectorStore.this.iResultSet.release();
                XVectorStore.this.iResultSet = null;
            }
            if (XVectorStore.this.refCount.decrementAndGet() == 0 && XVectorStore.this.cache != null) {
                try {
                    XVectorStore.this.cache.release();
                }
                catch (Exception e) {
                    mErrorLogger.log(e);
                }
                finally {
                    XVectorStore.this.cache = null;
                }
            }
            this.rowsetInfo = null;
        }

        private final class XVectorStoreIterator
        extends XVectorTabularIterator {
            private ITabularIterator tabIt;

            protected XVectorStoreIterator(XDataContext context) {
                super(context, XVectorStore.this.getId(), XVectorStoreResultSet.this.rowsetInfo);
                try {
                    this.startTimer();
                    this.tabIt = XVectorStore.this.cache.getTabularIterator(context, XVectorStore.this.vContext);
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextBatch() {
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                return this.tabIt.nextBatch();
            }

            @Override
            public long getIndex() {
                return this.tabIt.getIndex();
            }

            @Override
            public void release() {
                if (this.tabIt != null) {
                    try {
                        this.tabIt.release();
                    }
                    catch (Exception e) {
                        mErrorLogger.log(e);
                    }
                    finally {
                        this.tabIt = null;
                    }
                }
                super.release();
            }
        }
    }
}

