/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorTabularIterator;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;
import org.dom4j.Element;

public class XVectorTableValueConstructor
extends XTabularResultSet {
    private static final long serialVersionUID = 1L;
    private static final String ELEMENT_ROWSETINFO = "rowsetInfo";
    private RowsetInfo cRowsetInfo;

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XVectorTableConstructorResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501178;
    }

    @Override
    public XVectorContext getVectorizationContext() {
        return this.vContext;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        this.cRowsetInfo.dumpExtraInfo(trace);
    }

    public void setRowsetInfo(RowsetInfo rowsetInfo) {
        this.cRowsetInfo = rowsetInfo;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        List children = inputNode.elements();
        this.cRowsetInfo = new RowsetInfo();
        this.cRowsetInfo.capture(env, (Element)children.get(0));
        this.vContext = new XVectorContext();
        this.vContext.capture(env, (Element)children.get(1));
        super.capture(env, inputNode, 2);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.cRowsetInfo != null) {
            ctx.elementProperty(ELEMENT_ROWSETINFO, this.cRowsetInfo);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_ROWSETINFO)) {
            Object val = ctx.elementValue(node);
            this.cRowsetInfo = (RowsetInfo)val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    private final class XVectorTableConstructorResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        XVectorTableConstructorResultSet(XDataContext theContext) {
            super(theContext, XVectorTableValueConstructor.this.cRowsetInfo, XVectorTableValueConstructor.this.getId());
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XVectorTableConstructorIterator(this.getDataContext());
        }

        @Override
        public void releaseImpl() {
        }

        private final class XVectorTableConstructorIterator
        extends XVectorTabularIterator {
            private boolean eod;

            private XVectorTableConstructorIterator(XDataContext context) {
                super(context, XVectorTableValueConstructor.this.getId(), XVectorTableConstructorResultSet.this.rowsetInfo);
                this.nRows = 0;
                this.batch = XVectorRowBatchUtil.createRowBatch(XVectorTableValueConstructor.this.vContext, XVectorTableConstructorResultSet.this.rowsetInfo, context.getLocalCollator());
            }

            @Override
            public Object nextBatch() {
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                if (this.eod) {
                    this.batch.eod = true;
                    return this.batch;
                }
                this.batch.reset();
                ColumnVector[] columns = this.batch.columns;
                int size = 0;
                for (int i = 0; i < this.batch.maxBatchSize; ++i) {
                    if (this.nRows == XVectorTableValueConstructor.this.getNumberChildren()) {
                        this.eod = true;
                        break;
                    }
                    IRow row = (IRow)((XNode)XVectorTableValueConstructor.this.getChild(this.nRows++)).execute(this.context);
                    for (int j = 0; j < XVectorTableConstructorResultSet.this.rowsetInfo.getNumColumns(); ++j) {
                        Value value = (Value)row.getColumn(j);
                        ColumnVector vector = columns[j];
                        if (value.isNull()) {
                            vector.isNull[i] = true;
                            vector.noNulls = false;
                            continue;
                        }
                        vector.assign(i, value);
                    }
                    ++size;
                }
                this.batch.size = size;
                if (this.batch.size == 0) {
                    this.batch.eod = true;
                } else {
                    this.batch.complete(size);
                }
                return this.batch;
            }

            @Override
            public long getIndex() {
                return this.nRows;
            }

            @Override
            public void release() {
                super.release();
            }

            @Override
            public Object getVectorizationContext() {
                return XVectorTableValueConstructor.this.vContext;
            }
        }
    }
}

