/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.XSetOperator;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorTabularIterator;

public class XVectorUnion
extends XSetOperator {
    private static final long serialVersionUID = 1L;

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XVectorUnionResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501016;
    }

    private final class XVectorUnionResultSet
    extends XSetOperator.ResultSet
    implements ITabularResultSet {
        XVectorUnionResultSet(XDataContext theContext) {
            super(XVectorUnion.this, theContext);
        }

        @Override
        public IScrollableIterator getScrollableTabularIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XVectorUnionIterator(this.getDataContext());
        }

        private final class XVectorUnionIterator
        extends XVectorTabularIterator {
            private ITabularResultSet[] children;
            private XTabularIterator tabIt;
            private int current;

            private XVectorUnionIterator(XDataContext context) {
                super(context, XVectorUnion.this.getId(), XVectorUnionResultSet.this.rowsetInfo);
                try {
                    this.startTimer();
                    this.children = XVectorUnionResultSet.this.iResultSets;
                    this.tabIt = (XTabularIterator)XVectorUnionResultSet.this.iResultSets[0].getTabularIterator();
                    this.batch = XVectorRowBatchUtil.createRowBatch(XVectorUnion.this.vContext, XVectorUnionResultSet.this.rowsetInfo, context.getLocalCollator());
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextBatch() {
                XVectorRowBatch inputBatch = null;
                this.batch.reset();
                while (this.tabIt != null) {
                    inputBatch = (XVectorRowBatch)this.tabIt.nextBatch();
                    if (!inputBatch.eod) {
                        this.batch.copyFrom(inputBatch);
                        this.nRows += inputBatch.size;
                        break;
                    }
                    if (++this.current < XVectorUnion.this.getNumberChildren()) {
                        if (this.tabIt != null) {
                            this.tabIt.release();
                        }
                        this.tabIt = (XTabularIterator)this.children[this.current].getTabularIterator();
                        continue;
                    }
                    this.batch.eod = true;
                    break;
                }
                return this.batch;
            }

            @Override
            public long getIndex() {
                return this.nRows;
            }

            @Override
            public void release() {
                if (this.tabIt != null) {
                    try {
                        this.tabIt.release();
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.tabIt = null;
                    }
                }
                super.release();
            }

            @Override
            public Object getVectorizationContext() {
                return XVectorUnion.this.vContext;
            }
        }
    }
}

