/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions;

import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.DoubleColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;

public abstract class XVectorNumericFunctionLong
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int columnNo;
    private int outputColumnNo;

    protected abstract double getResult(long var1);

    public XVectorNumericFunctionLong(int inColumnNo, int inOutputColumnNo) {
        this.columnNo = inColumnNo;
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        int[] selected = batch.selected;
        LongColumnVector inputColVector = (LongColumnVector)batch.columns[this.columnNo];
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.columns[this.outputColumnNo];
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.noNulls = inputColVector.noNulls;
        long[] vector = inputColVector.vector;
        double[] outputVector = outputColVector.vector;
        if (inputColVector.isRepeating) {
            outputVector[0] = this.getResult(vector[0]);
            outputIsNull[0] = inputIsNull[0];
            outputColVector.isRepeating = true;
        } else if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputVector[i] = this.getResult(vector[i]);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = this.getResult(vector[i]);
                }
            }
            outputColVector.isRepeating = false;
        } else {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputVector[i] = this.getResult(vector[i]);
                    outputIsNull[i] = inputIsNull[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = this.getResult(vector[i]);
                }
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
            }
            outputColVector.isRepeating = false;
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", this.columnNo);
        trace.attribute("outputColumnNo", this.outputColumnNo);
    }
}

