/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.cast;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.DoubleColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class XVectorCastDoubleToLong
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int columnNo;
    private int outputColumnNo;

    public XVectorCastDoubleToLong(int inColumnNo, int inOutputColumnNo) {
        this.columnNo = inColumnNo;
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        int[] selected = batch.selected;
        DoubleColumnVector inputColVector = (DoubleColumnVector)batch.columns[this.columnNo];
        LongColumnVector outputColVector = (LongColumnVector)batch.columns[this.outputColumnNo];
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.noNulls = inputColVector.noNulls;
        double[] vector = inputColVector.vector;
        long[] outputVector = outputColVector.vector;
        if (inputColVector.isRepeating) {
            outputVector[0] = (long)vector[0];
            outputIsNull[0] = inputIsNull[0];
            outputColVector.isRepeating = true;
        } else if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputVector[i] = (long)vector[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = (long)vector[i];
                }
            }
            outputColVector.isRepeating = false;
        } else {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputVector[i] = (long)vector[i];
                    outputIsNull[i] = inputIsNull[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = (long)vector[i];
                }
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
            }
            outputColVector.isRepeating = false;
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("dataType", this.dataType.toString());
        trace.attribute("columnNo", this.columnNo);
        trace.attribute("outputColumnNo", this.outputColumnNo);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.dataType = DataTypeFactory.getType(inputNode.attribute("dataType").getValue());
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue("outputColumnNo"));
        super.capture(env, inputNode);
    }
}

