/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.cast;

import com.cognos.xqe.data.types.CharType;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.StringUtil;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorFunctionLongToString;
import com.cognos.xqe.util.MathUtil;
import java.math.BigInteger;

public class XVectorCastLongToString
extends XVectorFunctionLongToString {
    private static final long serialVersionUID = 1L;

    public XVectorCastLongToString(int inColumnNo, int outColumnNo) {
        super(inColumnNo, outColumnNo);
    }

    @Override
    protected void getResult(StringColumnVector outputVector, LongColumnVector inputVector, int i) {
        if (inputVector.isNull[i]) {
            outputVector.isNull[i] = true;
            return;
        }
        long value = inputVector.vector[i];
        int scale = inputVector.getDataType().getScale();
        String result = scale == 0 ? Long.toString(value) : (scale < 0 ? new BigInteger(String.valueOf(value * (long)MathUtil.pow10(-scale))).toString() : Double.toString((double)value / MathUtil.pow10(scale)));
        if (this.dataType instanceof CharType && result.length() < this.dataType.getPrecision()) {
            result = StringUtil.rPad(result, this.dataType.getPrecision(), " ");
        }
        outputVector.set(i, result);
    }
}

