/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.cast;

import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorFunctionStringToLong;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class XVectorCastStringToDate
extends XVectorFunctionStringToLong {
    private static final long serialVersionUID = 1L;
    public static final String SAP_DATE_FORMAT = "yyyyMMdd";
    private static final String[] DATE_PATTERNS = new String[]{"yyyy-MM-dd", "yyyyMMdd"};

    public XVectorCastStringToDate(int inColumnNo, int outColumnNo) {
        super(inColumnNo, outColumnNo);
    }

    @Override
    protected void getResult(LongColumnVector outputVector, StringColumnVector inputVector, int i) {
        String value = inputVector.vector[i];
        if (inputVector.isNull[i] || value.isEmpty()) {
            outputVector.setNull(i);
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ParsePosition pp = new ParsePosition(0);
        for (String pattern : DATE_PATTERNS) {
            pp.setErrorIndex(-1);
            pp.setIndex(0);
            sdf.applyPattern(pattern);
            sdf.parse(value, pp);
            if (pp.getErrorIndex() != -1 || pp.getIndex() != pattern.length()) continue;
            Date d = sdf.getCalendar().getTime();
            outputVector.set(i, d.getTime());
            return;
        }
        if (this.getOnErrorPolicy() == SQLAbstractFunction.OnErrorPolicy.ERROR) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", value, "date");
        }
        outputVector.setNull(i);
    }
}

