/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.cast;

import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.data.providers.relational.LOCALCastFormatter;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.ObjectValue;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorFunctionStringToLong;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.ArrayList;

public class XVectorCastStringToDateWithFormat
extends XVectorFunctionStringToLong {
    private static final long serialVersionUID = 1L;
    private DateTimeFormatter dtf;
    private ArrayList<ChronoField> accessors;

    public XVectorCastStringToDateWithFormat(int inColumnNo, ObjectValue o, int outColumnNo) {
        super(inColumnNo, outColumnNo);
        Object[] objArray = (Object[])o.getObject();
        this.dtf = (DateTimeFormatter)objArray[0];
        this.accessors = (ArrayList)objArray[1];
    }

    @Override
    protected void getResult(LongColumnVector outputVector, StringColumnVector inputVector, int i) {
        String value = inputVector.vector[i];
        if (inputVector.isNull[i] || value.isEmpty()) {
            outputVector.setNull(i);
            return;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            sdf.parse(LOCALCastFormatter.getInstance().convertToISOStandardFormat(value, DataTypeFactory.getDateType(), this.accessors, this.dtf));
            outputVector.set(i, sdf.getCalendar().getTime().getTime());
        }
        catch (DateTimeParseException e) {
            if (this.getOnErrorPolicy() == SQLAbstractFunction.OnErrorPolicy.ERROR) {
                throw e;
            }
            outputVector.isNull[i] = true;
        }
        catch (Exception e) {
            if (this.getOnErrorPolicy() == SQLAbstractFunction.OnErrorPolicy.ERROR) {
                throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", value, "date");
            }
            outputVector.setNull(i);
        }
    }
}

