/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.cast;

import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.expressions.XVectorFunctionStringToTimestamp;

public class XVectorCastStringToTime
extends XVectorFunctionStringToTimestamp {
    private static final long serialVersionUID = 1L;

    public XVectorCastStringToTime(int inColumnNo, int outColumnNo) {
        super(inColumnNo, outColumnNo);
    }

    @Override
    protected void getResult(TimestampColumnVector outputVector, StringColumnVector inputVector, int i) {
        String value = inputVector.vector[i];
        if (inputVector.isNull[i] || value.isEmpty()) {
            outputVector.setNull(i);
            return;
        }
        try {
            this.tsUtil.parseTime(value, outputVector.vector[i]);
        }
        catch (RuntimeException e) {
            if (this.getOnErrorPolicy() == SQLAbstractFunction.OnErrorPolicy.ERROR) {
                throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", value, "time");
            }
            outputVector.setNull(i);
        }
    }
}

