/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.cast;

import com.cognos.xqe.data.types.CharType;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.StringUtil;
import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import java.util.GregorianCalendar;

public class XVectorCastTimeToString
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    protected static GregorianCalendar calendar = new GregorianCalendar();
    protected int columnNo;
    protected int outputColumnNo;

    public XVectorCastTimeToString(int inColumnNo, int outColumnNo) {
        this.columnNo = inColumnNo;
        this.outputColumnNo = outColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        TimestampColumnVector inputColumnVector = (TimestampColumnVector)batch.columns[this.columnNo];
        StringColumnVector outputColumnVector = (StringColumnVector)batch.columns[this.outputColumnNo];
        int[] selected = batch.selected;
        if (inputColumnVector.noNulls) {
            outputColumnVector.noNulls = true;
            if (inputColumnVector.isRepeating) {
                outputColumnVector.isRepeating = true;
                this.getResult(outputColumnVector, inputColumnVector, 0);
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    this.getResult(outputColumnVector, inputColumnVector, i);
                }
                outputColumnVector.isRepeating = false;
            } else {
                for (int i = 0; i != n; ++i) {
                    this.getResult(outputColumnVector, inputColumnVector, i);
                }
                outputColumnVector.isRepeating = false;
            }
        } else {
            outputColumnVector.noNulls = false;
            if (inputColumnVector.isRepeating) {
                outputColumnVector.isRepeating = true;
                outputColumnVector.isNull[0] = inputColumnVector.isNull[0];
                if (!inputColumnVector.isNull[0]) {
                    this.getResult(outputColumnVector, inputColumnVector, 0);
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputColumnVector.isNull[i] = inputColumnVector.isNull[i];
                    if (inputColumnVector.isNull[i]) continue;
                    this.getResult(outputColumnVector, inputColumnVector, i);
                }
                outputColumnVector.isRepeating = false;
            } else {
                System.arraycopy(inputColumnVector.isNull, 0, outputColumnVector.isNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    if (inputColumnVector.isNull[i]) continue;
                    this.getResult(outputColumnVector, inputColumnVector, i);
                }
                outputColumnVector.isRepeating = false;
            }
        }
    }

    protected void getResult(StringColumnVector outputVector, TimestampColumnVector inputVector, int i) {
        if (inputVector.isNull[i]) {
            outputVector.isNull[i] = true;
            return;
        }
        TimestampColumnVector.UnixTimestamp uxTimestamp = inputVector.vector[i];
        calendar.setTimeInMillis(uxTimestamp.milliseconds);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        String result = uxTimestamp.nanoseconds > 0 ? String.format("%1$02d:%2$02d:%3$02d.%4$09d", hour, minute, second, uxTimestamp.nanoseconds) : String.format("%1$02d:%2$02d:%3$02d", hour, minute, second);
        if (this.dataType instanceof CharType && result.length() < this.dataType.getPrecision()) {
            result = StringUtil.rPad(result, this.dataType.getPrecision(), " ");
        }
        outputVector.set(i, result);
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("dataType", this.dataType.toString());
        trace.attribute("columnNo", String.valueOf(this.columnNo));
        trace.attribute("outputColumnNo", String.valueOf(this.outputColumnNo));
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }

    static {
        calendar.setFirstDayOfWeek(2);
        calendar.setMinimalDaysInFirstWeek(4);
        calendar.clear();
    }
}

