/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.cast;

import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import java.util.GregorianCalendar;

public class XVectorCastTimestampToDate
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int columnNo;
    private int outputColumnNo;
    private final GregorianCalendar calendar = new GregorianCalendar();

    public XVectorCastTimestampToDate(int inColumnNo, int inOutputColumnNo) {
        this.columnNo = inColumnNo;
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        int[] selected = batch.selected;
        TimestampColumnVector inputColumnVector = (TimestampColumnVector)batch.columns[this.columnNo];
        LongColumnVector outputColumnVector = (LongColumnVector)batch.columns[this.outputColumnNo];
        boolean[] inputIsNull = inputColumnVector.isNull;
        boolean[] outputIsNull = outputColumnVector.isNull;
        outputColumnVector.noNulls = inputColumnVector.noNulls;
        if (inputColumnVector.isRepeating) {
            outputIsNull[0] = inputIsNull[0];
            outputColumnVector.isRepeating = true;
            this.getResult(context, outputColumnVector, inputColumnVector, 0);
        } else if (inputColumnVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    this.getResult(context, outputColumnVector, inputColumnVector, i);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    this.getResult(context, outputColumnVector, inputColumnVector, i);
                }
            }
            outputColumnVector.isRepeating = false;
        } else {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    this.getResult(context, outputColumnVector, inputColumnVector, i);
                    outputIsNull[i] = inputIsNull[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    this.getResult(context, outputColumnVector, inputColumnVector, i);
                }
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
            }
            outputColumnVector.isRepeating = false;
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    protected void getResult(XDataContext context, LongColumnVector outputColumnVector, TimestampColumnVector inputColumnVector, int i) {
        if (inputColumnVector.isNull[i]) {
            outputColumnVector.isNull[i] = true;
            return;
        }
        this.calendar.clear();
        this.calendar.setTimeInMillis(inputColumnVector.vector[i].milliseconds);
        this.calendar.set(11, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        outputColumnVector.vector[i] = this.calendar.getTimeInMillis();
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("dataType", this.dataType.toString());
        trace.attribute("columnNo", String.valueOf(this.columnNo));
        trace.attribute("outputColumnNo", String.valueOf(this.outputColumnNo));
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }
}

