/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.cast;

import com.cognos.xqe.data.types.CharType;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.StringUtil;
import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastTimeToString;

public class XVectorCastTimestampToString
extends XVectorCastTimeToString {
    private static final long serialVersionUID = 1L;

    public XVectorCastTimestampToString(int inColumnNo, int outColumnNo) {
        super(inColumnNo, outColumnNo);
    }

    @Override
    protected void getResult(StringColumnVector outputVector, TimestampColumnVector inputVector, int i) {
        if (inputVector.isNull[i]) {
            outputVector.isNull[i] = true;
            return;
        }
        TimestampColumnVector.UnixTimestamp uxTimestamp = inputVector.vector[i];
        calendar.setTimeInMillis(uxTimestamp.milliseconds);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        String result = uxTimestamp.nanoseconds > 0 ? String.format("%1$4d-%2$02d-%3$02d %4$02d:%5$02d:%6$02d.%7$09d", year, month, day, hour, minute, second, uxTimestamp.nanoseconds) : String.format("%1$04d-%2$02d-%3$02d %4$02d:%5$02d:%6$02d", year, month, day, hour, minute, second);
        if (this.dataType instanceof CharType && result.length() < this.dataType.getPrecision()) {
            result = StringUtil.rPad(result, this.dataType.getPrecision(), " ");
        }
        outputVector.set(i, result);
    }
}

