/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.character;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class XVectorStringScalarConcatStringColumn
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int columnNo;
    private int outputColumnNo;
    private String value;

    public XVectorStringScalarConcatStringColumn(String inValue, int inColumnNo, int inOutputColumnNo) {
        this.value = inValue;
        this.columnNo = inColumnNo;
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        super.evaluate(context, batch);
        int[] selected = batch.selected;
        StringColumnVector inputColumnVector = (StringColumnVector)batch.columns[this.columnNo];
        StringColumnVector outputColumnVector = (StringColumnVector)batch.columns[this.outputColumnNo];
        String[] vector = inputColumnVector.vector;
        if (inputColumnVector.noNulls) {
            outputColumnVector.noNulls = true;
            if (inputColumnVector.isRepeating) {
                outputColumnVector.isRepeating = true;
                outputColumnVector.append(0, this.value, vector[0]);
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputColumnVector.append(i, this.value, vector[i]);
                }
                outputColumnVector.isRepeating = false;
            } else {
                for (int i = 0; i != n; ++i) {
                    outputColumnVector.append(i, this.value, vector[i]);
                }
                outputColumnVector.isRepeating = false;
            }
        } else {
            outputColumnVector.noNulls = false;
            if (inputColumnVector.isRepeating) {
                outputColumnVector.isRepeating = true;
                outputColumnVector.isNull[0] = inputColumnVector.isNull[0];
                if (!inputColumnVector.isNull[0]) {
                    outputColumnVector.append(0, this.value, vector[0]);
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    if (!inputColumnVector.isNull[i]) {
                        outputColumnVector.append(i, this.value, vector[i]);
                    }
                    outputColumnVector.isNull[i] = inputColumnVector.isNull[i];
                }
                outputColumnVector.isRepeating = false;
            } else {
                for (int i = 0; i != n; ++i) {
                    if (!inputColumnVector.isNull[i]) {
                        outputColumnVector.append(i, this.value, vector[i]);
                    }
                    outputColumnVector.isNull[i] = inputColumnVector.isNull[i];
                }
                outputColumnVector.isRepeating = false;
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("dataType", this.dataType);
        trace.attribute("columnNo", this.columnNo);
        trace.attribute("value", String.valueOf(this.value));
        trace.attribute("outputColumnNo", this.outputColumnNo);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.dataType = DataTypeFactory.getType(inputNode.attribute("dataType").getValue());
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.value = inputNode.attributeValue("value");
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue("outputColumnNo"));
        super.capture(env, inputNode);
    }
}

