/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.character;

import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class XVectorSubstring
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_COLUMNNO = "columnNo";
    private static final String ATTRIBUTE_OUTPUTCOLUMNNO = "outputColumnNo";
    private static final String ATTRIBUTE_START = "start";
    private static final String ATTRIBUTE_LENGTH = "length";
    private static final String EMPTY_STRING = "";
    private int columnNo;
    private int outputColumnNo;
    private int start;
    private int length;

    public XVectorSubstring(int theColumnNo, Object theStartPosition, Object theNumberOfChars, int theOutputColumnNo) {
        this.columnNo = theColumnNo;
        this.start = ((Number)theStartPosition).intValue();
        this.length = ((Number)theNumberOfChars).intValue();
        this.outputColumnNo = theOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        int[] selected = batch.selected;
        StringColumnVector inputColumnVector = (StringColumnVector)batch.columns[this.columnNo];
        StringColumnVector outputColumnVector = (StringColumnVector)batch.columns[this.outputColumnNo];
        String[] vector = inputColumnVector.vector;
        if (inputColumnVector.isRepeating) {
            outputColumnVector.isRepeating = true;
            if (!inputColumnVector.noNulls && inputColumnVector.isNull[0]) {
                outputColumnVector.isNull[0] = true;
                outputColumnVector.noNulls = false;
            } else {
                outputColumnVector.noNulls = true;
                outputColumnVector.set(0, this.subString(vector[0]));
            }
        } else {
            outputColumnVector.isRepeating = false;
            if (batch.selectedInUse) {
                if (!inputColumnVector.noNulls) {
                    outputColumnVector.noNulls = false;
                    for (int i = 0; i != n; ++i) {
                        int j = selected[i];
                        if (!inputColumnVector.isNull[j]) {
                            outputColumnVector.isNull[j] = false;
                            outputColumnVector.set(j, this.subString(vector[j]));
                            continue;
                        }
                        outputColumnVector.isNull[j] = true;
                    }
                } else {
                    outputColumnVector.noNulls = true;
                    for (int i = 0; i != n; ++i) {
                        int j = selected[i];
                        outputColumnVector.isNull[j] = false;
                        outputColumnVector.set(j, this.subString(vector[j]));
                    }
                }
            } else if (!inputColumnVector.noNulls) {
                System.arraycopy(inputColumnVector.isNull, 0, outputColumnVector.isNull, 0, n);
                outputColumnVector.noNulls = false;
                for (int i = 0; i != n; ++i) {
                    if (inputColumnVector.isNull[i]) continue;
                    outputColumnVector.set(i, this.subString(vector[i]));
                }
            } else {
                outputColumnVector.noNulls = true;
                for (int i = 0; i != n; ++i) {
                    outputColumnVector.isNull[i] = false;
                    outputColumnVector.set(i, this.subString(vector[i]));
                }
            }
        }
    }

    private String subString(String value) {
        int inputStrLenInCodeunits = value.length();
        int inputStrLenInChars = Character.codePointCount(value, 0, inputStrLenInCodeunits);
        if (this.start > inputStrLenInChars) {
            return EMPTY_STRING;
        }
        if (this.start < 1) {
            if (this.length < 0) {
                return value;
            }
            return EMPTY_STRING;
        }
        if (this.length < 0) {
            int cpOffset = value.offsetByCodePoints(0, this.start - 1);
            return value.substring(cpOffset);
        }
        if (this.length < 1) {
            return EMPTY_STRING;
        }
        if (this.start == 0) {
            this.start = 1;
        }
        if (this.start < 0) {
            this.start = this.start + inputStrLenInChars + 1;
        }
        if (this.start < 1) {
            return EMPTY_STRING;
        }
        int endPosition = this.start + this.length - 1;
        int begin = value.offsetByCodePoints(0, this.start - 1);
        if (endPosition >= inputStrLenInChars) {
            return value.substring(begin);
        }
        int end = value.offsetByCodePoints(0, endPosition);
        return value.substring(begin, end);
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_COLUMNNO, this.columnNo);
        trace.attribute(ATTRIBUTE_OUTPUTCOLUMNNO, this.outputColumnNo);
        trace.attribute(ATTRIBUTE_START, this.start);
        trace.attribute(ATTRIBUTE_LENGTH, this.length);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue(ATTRIBUTE_COLUMNNO));
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue(ATTRIBUTE_OUTPUTCOLUMNNO));
        this.start = Integer.valueOf(inputNode.attributeValue(ATTRIBUTE_START));
        this.length = Integer.valueOf(inputNode.attributeValue(ATTRIBUTE_LENGTH));
        super.capture(env, inputNode);
    }
}

