/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.character;

import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.relational.vectorization.expressions.XVectorStringFunction;
import com.cognos.xqe.trace.XQETrace;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class XVectorTrim
extends XVectorStringFunction {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_TRIMSPEC = "trimSpec";
    private static final String ATTRIBUTE_TRIMCHAR = "trimChar";
    private static final int TRAILING = 1;
    private static final int LEADING = 2;
    private static final int BOTH = 3;
    private String[] trimSpecAsString = new String[]{"TRAILING", "LEADING", "BOTH"};

    public XVectorTrim() {
    }

    public XVectorTrim(long trimSpec, String trimChar, int columnNo, int outputColumnNo) {
        super(columnNo, outputColumnNo, new TrimFunction(trimSpec, trimChar));
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        trace.attribute(ATTRIBUTE_TRIMSPEC, this.trimSpecAsString[(int)(((TrimFunction)this.function).trimSpec - 1L)]);
        trace.attribute(ATTRIBUTE_TRIMCHAR, ((TrimFunction)this.function).trimChar);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        long trimSpec = Long.valueOf(inputNode.attributeValue(ATTRIBUTE_TRIMSPEC));
        String trimChar = inputNode.attributeValue(ATTRIBUTE_TRIMCHAR);
        this.function = new TrimFunction(trimSpec, trimChar);
        super.capture(env, inputNode);
    }

    private static class TrimFunction
    implements XVectorStringFunction.IUnaryStringFunction {
        private long trimSpec;
        private String trimChar;

        TrimFunction(long theTrimSpec, String theTrimChar) {
            this.trimSpec = theTrimSpec;
            this.trimChar = theTrimChar;
        }

        @Override
        public String evaluate(String s) {
            if (s == null) {
                return null;
            }
            if (this.trimSpec == 2L) {
                return StringUtils.stripStart((String)s, (String)this.trimChar);
            }
            if (this.trimSpec == 1L) {
                return StringUtils.stripEnd((String)s, (String)this.trimChar);
            }
            if (this.trimSpec == 3L) {
                return StringUtils.strip((String)s, (String)this.trimChar);
            }
            throw new IllegalArgumentException();
        }
    }
}

