/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.conditional;

import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.trace.XQETrace;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.dom4j.Element;

public abstract class AbstractLikeColumnScalar
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_PATTERN = "pattern";
    protected static final String UTF_8 = "UTF-8";
    protected int columnNo;
    protected String pattern;
    protected String escCharOrFlags;

    protected abstract List<PatternMatcherFactory> getPatternMatcherFactories();

    protected AbstractLikeColumnScalar() {
    }

    protected AbstractLikeColumnScalar(int inColumnNo, String inPattern, String inEscCharOrFlags) {
        this.columnNo = inColumnNo;
        this.pattern = inPattern;
        this.escCharOrFlags = inEscCharOrFlags;
    }

    protected PatternMatcher createPatternMatcher(XDataContext context) {
        for (PatternMatcherFactory factory : this.getPatternMatcherFactories()) {
            PatternMatcher checker = factory.tryCreate(context, this.pattern, this.escCharOrFlags);
            if (checker == null) continue;
            return checker;
        }
        return null;
    }

    @Override
    public int getColumnNo() {
        return this.columnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", this.columnNo);
        trace.attribute(ATTRIBUTE_PATTERN, this.pattern);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.pattern = inputNode.attributeValue(ATTRIBUTE_PATTERN);
        super.capture(env, inputNode);
    }

    public static class ContainsPatternMatcher
    implements PatternMatcher {
        private byte[] bytesToMatch;
        private int lengthToMatch;

        public ContainsPatternMatcher(String pattern) {
            try {
                this.bytesToMatch = pattern.getBytes(AbstractLikeColumnScalar.UTF_8);
                this.lengthToMatch = this.bytesToMatch.length;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean check(byte[] byteS, int len) {
            if (len < this.lengthToMatch) {
                return false;
            }
            int end = len - this.lengthToMatch + 1;
            boolean match = false;
            for (int i = 0; i < end; ++i) {
                match = true;
                for (int j = 0; j < this.lengthToMatch; ++j) {
                    if (byteS[i + j] == this.bytesToMatch[j]) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                return true;
            }
            return match;
        }
    }

    public static class EndsWithPatternMatcher
    implements PatternMatcher {
        private byte[] bytesToMatch;

        public EndsWithPatternMatcher(String pattern) {
            try {
                this.bytesToMatch = pattern.getBytes(AbstractLikeColumnScalar.UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean check(byte[] source, int length) {
            int patternLength = this.bytesToMatch.length;
            if (length < patternLength) {
                return false;
            }
            int i = length - patternLength;
            for (int j = 0; j < patternLength; ++j) {
                if (source[i] != this.bytesToMatch[j]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    public static class StartsWithPatternMatcher
    implements PatternMatcher {
        private byte[] bytesToMatch;

        public StartsWithPatternMatcher(String pattern) {
            try {
                this.bytesToMatch = pattern.getBytes(AbstractLikeColumnScalar.UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean check(byte[] byteS, int len) {
            if (len < this.bytesToMatch.length) {
                return false;
            }
            int i = 0;
            for (int j = 0; j < this.bytesToMatch.length; ++j) {
                if (byteS[i] != this.bytesToMatch[j]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    public static class NonePatternMatcher
    implements PatternMatcher {
        private byte[] bytesToMatch;

        public NonePatternMatcher(String pattern) {
            try {
                this.bytesToMatch = pattern.getBytes(AbstractLikeColumnScalar.UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean check(byte[] byteS, int len) {
            int lenSub = this.bytesToMatch.length;
            if (len != lenSub) {
                return false;
            }
            int i = 0;
            for (int j = 0; j < len; ++j) {
                if (byteS[i] != this.bytesToMatch[j]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    public static interface PatternMatcherFactory {
        public PatternMatcher tryCreate(XDataContext var1, String var2, String var3);
    }

    public static interface PatternMatcher {
        public boolean check(byte[] var1, int var2);
    }
}

