/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.conditional;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import com.google.common.hash.BloomFilter;
import org.dom4j.Element;

public class XVectorBloomFilter
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    public static final String ELEMENT_VALUELIST = "ValueList";
    public static final String ELEMENT_VALUE = "Value";
    private static final String ATTRIBUTE_NAME = "name";
    private int columnNo;
    private String bfName = "BF";

    public XVectorBloomFilter() {
    }

    public XVectorBloomFilter(int inColumnNo) {
        this.columnNo = inColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) throws XQERuntimeException {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        int[] selected = batch.selected;
        ColumnVector inputColumnVector = batch.columns[this.columnNo];
        boolean[] isNull = inputColumnVector.isNull;
        BloomFilter<byte[]> bloomFilter = context.getBloomFilter(this.bfName);
        if (inputColumnVector.noNulls) {
            if (inputColumnVector.isRepeating) {
                if (!bloomFilter.mightContain((Object)inputColumnVector.getBytes(0))) {
                    batch.size = 0;
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j < n; ++j) {
                    int i = selected[j];
                    if (!bloomFilter.mightContain((Object)inputColumnVector.getBytes(i))) continue;
                    selected[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            } else {
                int newSize = 0;
                for (int i = 0; i < n; ++i) {
                    if (!bloomFilter.mightContain((Object)inputColumnVector.getBytes(i))) continue;
                    selected[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColumnVector.isRepeating) {
            if (!isNull[0]) {
                if (bloomFilter.mightContain((Object)inputColumnVector.getBytes(0))) {
                    batch.size = 0;
                }
            } else {
                batch.size = 0;
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j < n; ++j) {
                int i = selected[j];
                if (isNull[i] || !bloomFilter.mightContain((Object)inputColumnVector.getBytes(i))) continue;
                selected[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        } else {
            int newSize = 0;
            for (int i = 0; i < n; ++i) {
                if (isNull[i] || !bloomFilter.mightContain((Object)inputColumnVector.getBytes(i))) continue;
                selected[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", this.columnNo);
        trace.attribute(ATTRIBUTE_NAME, this.bfName);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.bfName = inputNode.attributeValue(ATTRIBUTE_NAME);
        super.capture(env, inputNode);
    }
}

