/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.conditional;

import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.DoubleColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.expressions.conditional.XVectorFilterInList;
import com.cognos.xqe.trace.XQETrace;

public class XVectorFilterInListDouble
extends XVectorFilterInList {
    private static final long serialVersionUID = 1L;
    private double[] valueList;

    public XVectorFilterInListDouble(int inColumnNo, Object[] inValueList) {
        super(inColumnNo);
        this.valueList = new double[inValueList.length];
        for (int i = 0; i < inValueList.length; ++i) {
            this.valueList[i] = ((Number)inValueList[i]).doubleValue();
        }
    }

    @Override
    protected boolean contains(ColumnVector inputColumnVector, int index) {
        for (double value : this.valueList) {
            if (Double.compare(value, ((DoubleColumnVector)inputColumnVector).vector[index]) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dumpValues(XQETrace trace) {
        trace.beginElement("ValueList");
        for (int i = 0; i < this.valueList.length; ++i) {
            trace.beginElement("Value");
            trace.data(String.valueOf(this.valueList[i]));
            trace.endElement();
        }
        trace.endElement();
    }
}

