/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.conditional;

import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;

public class XVectorFilterIsNotNull
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_COLUMNNO = "columnNo";
    private int columnNo;

    public XVectorFilterIsNotNull(int colNum) {
        this.columnNo = colNum;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        ColumnVector inputColVector = batch.columns[this.columnNo];
        int[] selected = batch.selected;
        boolean[] nullPos = inputColVector.isNull;
        if (inputColVector.noNulls) {
            return;
        }
        if (inputColVector.isRepeating) {
            if (nullPos[0]) {
                batch.size = 0;
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = selected[j];
                if (nullPos[i]) continue;
                selected[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            int newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (nullPos[i]) continue;
                selected[newSize++] = i;
            }
            if (newSize < n) {
                batch.selectedInUse = true;
                batch.size = newSize;
            }
        }
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_COLUMNNO, String.valueOf(this.columnNo));
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }
}

