/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.conditional;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.expressions.conditional.LikeColumnScalar;
import java.io.UnsupportedEncodingException;

public class XVectorFilterLikeColumnScalar
extends LikeColumnScalar {
    private static final long serialVersionUID = 1L;

    public XVectorFilterLikeColumnScalar(int inColumnNo, String inPattern, String escChar) {
        super(inColumnNo, inPattern, escChar);
    }

    public XVectorFilterLikeColumnScalar() {
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) throws XQERuntimeException {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.matcher == null) {
            this.matcher = this.createPatternMatcher(context);
        }
        int[] selected = batch.selected;
        StringColumnVector inputColumnVector = (StringColumnVector)batch.columns[this.columnNo];
        boolean[] isNull = inputColumnVector.isNull;
        String[] vector = inputColumnVector.vector;
        try {
            if (inputColumnVector.noNulls) {
                if (inputColumnVector.isRepeating) {
                    byte[] x = vector[0].getBytes("UTF-8");
                    if (!this.matcher.check(x, x.length)) {
                        batch.size = 0;
                    }
                } else if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j < n; ++j) {
                        int i = selected[j];
                        byte[] x = vector[i].getBytes("UTF-8");
                        if (!this.matcher.check(x, x.length)) continue;
                        selected[newSize++] = i;
                    }
                    if (newSize < n) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                } else {
                    int newSize = 0;
                    for (int i = 0; i < n; ++i) {
                        byte[] x = vector[i].getBytes("UTF-8");
                        if (!this.matcher.check(x, x.length)) continue;
                        selected[newSize++] = i;
                    }
                    if (newSize < n) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (inputColumnVector.isRepeating) {
                if (!isNull[0]) {
                    byte[] x = vector[0].getBytes("UTF-8");
                    if (!this.matcher.check(x, x.length)) {
                        batch.size = 0;
                    }
                } else {
                    batch.size = 0;
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j < n; ++j) {
                    byte[] x;
                    int i = selected[j];
                    if (isNull[i] || !this.matcher.check(x = vector[i].getBytes("UTF-8"), x.length)) continue;
                    selected[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            } else {
                int newSize = 0;
                for (int i = 0; i < n; ++i) {
                    byte[] x;
                    if (isNull[i] || !this.matcher.check(x = vector[i].getBytes("UTF-8"), x.length)) continue;
                    selected[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL, (Throwable)e);
        }
    }
}

