/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.conditional;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.expressions.conditional.IVectorInList;
import com.cognos.xqe.trace.XQETrace;
import java.util.Arrays;

public abstract class XVectorInList
extends XVectorExpression
implements IVectorInList {
    private static final long serialVersionUID = 1L;
    public static final String ELEMENT_VALUELIST = "ValueList";
    public static final String ELEMENT_VALUE = "Value";
    private static final String ATTRIBUTE_NOT = "not";
    private boolean notIn;
    protected int columnNo;
    protected int outputColumnNo;

    public XVectorInList() {
    }

    public XVectorInList(int inColumnNo, int inOutputColumnNo) {
        this.columnNo = inColumnNo;
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) throws XQERuntimeException {
        block16: {
            long v1;
            boolean[] inputIsNull;
            ColumnVector inputColumnVector;
            int[] selected;
            int n;
            block17: {
                block18: {
                    block15: {
                        super.evaluate(context, batch);
                        n = batch.size;
                        if (n == 0) {
                            return;
                        }
                        selected = batch.selected;
                        inputColumnVector = batch.columns[this.columnNo];
                        LongColumnVector outputColumnVector = (LongColumnVector)batch.columns[this.outputColumnNo];
                        inputIsNull = inputColumnVector.isNull;
                        long[] outputVector = outputColumnVector.vector;
                        v1 = 1L;
                        long v2 = 0L;
                        if (this.notIn) {
                            v1 = 0L;
                            v2 = 1L;
                        }
                        Arrays.fill(outputVector, v2);
                        if (!inputColumnVector.noNulls) break block15;
                        if (inputColumnVector.isRepeating) {
                            if (this.contains(inputColumnVector, 0)) {
                                outputVector[0] = v1;
                            }
                            outputColumnVector.isRepeating = true;
                        } else if (batch.selectedInUse) {
                            for (int j = 0; j < n; ++j) {
                                int i = selected[j];
                                if (!this.contains(inputColumnVector, i)) continue;
                                outputVector[i] = v1;
                            }
                        } else {
                            for (int i = 0; i < n; ++i) {
                                if (!this.contains(inputColumnVector, i)) continue;
                                outputVector[i] = v1;
                            }
                        }
                        break block16;
                    }
                    if (!inputColumnVector.isRepeating) break block17;
                    if (inputIsNull[0]) break block18;
                    if (!this.contains(inputColumnVector, 0)) break block16;
                    outputVector[0] = v1;
                    break block16;
                }
                outputVector[0] = 0L;
                break block16;
            }
            if (batch.selectedInUse) {
                for (int j = 0; j < n; ++j) {
                    int i = selected[j];
                    if (!inputIsNull[i]) {
                        if (!this.contains(inputColumnVector, i)) continue;
                        outputVector[i] = v1;
                        continue;
                    }
                    outputVector[0] = 0L;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    if (!inputIsNull[i]) {
                        if (!this.contains(inputColumnVector, i)) continue;
                        outputVector[i] = v1;
                        continue;
                    }
                    outputVector[0] = 0L;
                }
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", this.columnNo);
        trace.attribute("outputColumnNo", this.outputColumnNo);
        trace.attribute(ATTRIBUTE_NOT, this.notIn);
        this.dumpValues(trace);
    }

    protected abstract void dumpValues(XQETrace var1);

    protected abstract boolean contains(ColumnVector var1, int var2);

    @Override
    public void setNotIn(boolean not) {
        this.notIn = not;
    }
}

