/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.conditional;

import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.DecimalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.expressions.conditional.XVectorInList;
import com.cognos.xqe.trace.XQETrace;
import java.math.BigDecimal;

public class XVectorInListDecimal
extends XVectorInList {
    private static final long serialVersionUID = 1L;
    private BigDecimal[] valueList;

    public XVectorInListDecimal(int inColumnNo, Object[] inValueList, int inOutputColumnNo) {
        super(inColumnNo, inOutputColumnNo);
        this.valueList = new BigDecimal[inValueList.length];
        for (int i = 0; i < this.valueList.length; ++i) {
            this.valueList[i] = inValueList[i] instanceof BigDecimal ? (BigDecimal)inValueList[i] : (inValueList[i] instanceof Long ? BigDecimal.valueOf(((Number)inValueList[i]).longValue()) : BigDecimal.valueOf(((Number)inValueList[i]).doubleValue()));
        }
    }

    @Override
    protected boolean contains(ColumnVector inputColumnVector, int index) {
        for (BigDecimal value : this.valueList) {
            if (value.compareTo(((DecimalColumnVector)inputColumnVector).vector[index]) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dumpValues(XQETrace trace) {
        trace.beginElement("ValueList");
        for (int i = 0; i < this.valueList.length; ++i) {
            trace.beginElement("Value");
            trace.data(this.valueList[i].toPlainString());
            trace.endElement();
        }
        trace.endElement();
    }
}

