/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.conditional;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.NullUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;

public class XVectorLogicalAnd
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum1;
    private int colNum2;
    private int outputColumnNo;

    public XVectorLogicalAnd(int inColNum1, int inColNum2, int inOutputColumnNo) {
        this.colNum1 = inColNum1;
        this.colNum2 = inColNum2;
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) throws XQERuntimeException {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        int[] selected = batch.selected;
        LongColumnVector inputColumnVector1 = (LongColumnVector)batch.columns[this.colNum1];
        LongColumnVector inputColumnVector2 = (LongColumnVector)batch.columns[this.colNum2];
        LongColumnVector outputColumnVector = (LongColumnVector)batch.columns[this.outputColumnNo];
        long[] vector1 = inputColumnVector1.vector;
        long[] vector2 = inputColumnVector2.vector;
        long[] outputVector = outputColumnVector.vector;
        outputColumnVector.isRepeating = inputColumnVector1.isRepeating && inputColumnVector2.isRepeating || inputColumnVector1.isRepeating && !inputColumnVector1.noNulls && inputColumnVector1.isNull[0] || inputColumnVector2.isRepeating && !inputColumnVector2.noNulls && inputColumnVector2.isNull[0];
        NullUtil.propagateNulls(inputColumnVector1, inputColumnVector2, outputColumnVector, selected, n, batch.selectedInUse);
        if (inputColumnVector1.isRepeating && inputColumnVector2.isRepeating) {
            outputVector[0] = vector1[0] == 1L && vector2[0] == 1L ? 1L : 0L;
        } else if (inputColumnVector1.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputVector[i] = vector1[0] == 1L && vector2[i] == 1L ? 1L : 0L;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = vector1[0] == 1L && vector2[i] == 1L ? 1L : 0L;
                }
            }
        } else if (inputColumnVector2.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputVector[i] = vector1[i] == 1L && vector2[0] == 1L ? 1L : 0L;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = vector1[i] == 1L && vector2[0] == 1L ? 1L : 0L;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = selected[j];
                outputVector[i] = vector1[i] == 1L && vector2[i] == 1L ? 1L : 0L;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                outputVector[i] = vector1[i] == 1L && vector2[i] == 1L ? 1L : 0L;
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }
}

