/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.date;

import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorExtract;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public final class XVectorAge
extends XVectorExtract {
    private static final long serialVersionUID = 1L;
    private static final int YEAR_MULTIPLIER = 10000;
    private static final int MONTH_MULTIPLIER = 100;
    protected final Calendar today = (Calendar)GC_VALUE.clone();

    public XVectorAge(int columnNo, int outputColumnNo) {
        super(columnNo, outputColumnNo);
        this.today.setTime(new Date());
    }

    @Override
    protected void getResult(int index, LongColumnVector inputColumnVector, LongColumnVector outputColumnVector) {
        this.calendar.setTimeInMillis(inputColumnVector.vector[index]);
        outputColumnVector.vector[index] = this.calculateInterval();
    }

    @Override
    protected void getResult(int index, TimestampColumnVector inputColumnVector, ColumnVector outputColumnVector) {
        this.calendar.setTime(this.getTimestamp(inputColumnVector.vector[index]));
        ((LongColumnVector)outputColumnVector).vector[index] = this.calculateInterval();
    }

    public int calculateInterval() {
        int months = (this.today.get(1) - this.calendar.get(1)) * 12;
        int days = this.today.get(5) - this.calendar.get(5);
        GregorianCalendar t = new GregorianCalendar(this.today.get(1), this.today.get(2) - 1, this.today.getActualMinimum(5));
        if ((months += this.today.get(2) - this.calendar.get(2)) > 0 && days < 0) {
            --months;
            t.add(2, -1);
            days += t.getActualMaximum(5);
        } else if (months < 0 && days > 0) {
            ++months;
            days -= t.getActualMaximum(5);
        }
        int years = months / 12;
        int result = years * 10000 + (months %= 12) * 100 + days;
        return result;
    }
}

