/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.date;

import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorCurrentDate;

public class XVectorCurrentTime
extends XVectorCurrentDate {
    private static final long serialVersionUID = 1L;

    public XVectorCurrentTime(int outputColumnNo) {
        super(outputColumnNo);
    }

    @Override
    public int getType() {
        return -1;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        TimestampColumnVector outputColumnVector = (TimestampColumnVector)batch.columns[this.outputColumnNo];
        outputColumnVector.isRepeating = true;
        outputColumnVector.noNulls = true;
        DateTimeValue dtValue = context.getExecutionTime();
        TimestampColumnVector.UnixTimestamp uxTimestamp = outputColumnVector.vector[0];
        uxTimestamp.milliseconds = dtValue.getMilliseconds();
        uxTimestamp.nanoseconds = 0;
        uxTimestamp.timeZoneOffset = dtValue.getTimeZone().getRawOffset();
        XQEConfiguration config = XQEConfigurationManager.getInstance().getOrCreateXQEConfiguration();
        boolean considerDST = config.getBooleanProperty("general.includeDstInTimeZoneOffset[@enabled]", true);
        if (considerDST && dtValue.inDaylightTime()) {
            uxTimestamp.timeZoneOffset += dtValue.getTimeZone().getDSTSavings();
        }
    }
}

