/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.date;

import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.NullUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import java.util.GregorianCalendar;

public abstract class XVectorDuration
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    protected static final GregorianCalendar GC_VALUE = new GregorianCalendar();
    protected int leftColumnNo;
    protected int rightColumnNo;
    protected int outputColumnNo;

    protected XVectorDuration(int columnNo1, int columnNo2, int theOutputColumnNo) {
        this.leftColumnNo = columnNo1;
        this.rightColumnNo = columnNo2;
        this.outputColumnNo = theOutputColumnNo;
    }

    protected abstract long getResult(ColumnVector var1, int var2, ColumnVector var3, int var4);

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        ColumnVector inputColumnVector1 = batch.columns[this.leftColumnNo];
        ColumnVector inputColumnVector2 = batch.columns[this.rightColumnNo];
        LongColumnVector outputColumnVector = (LongColumnVector)batch.columns[this.outputColumnNo];
        long[] outputVector = outputColumnVector.vector;
        int[] selected = batch.selected;
        outputColumnVector.isRepeating = inputColumnVector1.isRepeating && inputColumnVector2.isRepeating || inputColumnVector1.isRepeating && !inputColumnVector1.noNulls && inputColumnVector1.isNull[0] || inputColumnVector2.isRepeating && !inputColumnVector2.noNulls && inputColumnVector2.isNull[0];
        NullUtil.propagateNulls(inputColumnVector1, inputColumnVector2, outputColumnVector, selected, n, batch.selectedInUse);
        if (inputColumnVector1.isRepeating && inputColumnVector2.isRepeating && outputColumnVector.noNulls) {
            outputVector[0] = this.getResult(inputColumnVector1, 0, inputColumnVector2, 0);
        } else if (inputColumnVector1.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    if (outputColumnVector.isNull[i]) continue;
                    outputVector[i] = this.getResult(inputColumnVector1, 0, inputColumnVector2, i);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    if (outputColumnVector.isNull[i]) continue;
                    outputVector[i] = this.getResult(inputColumnVector1, 0, inputColumnVector2, i);
                }
            }
        } else if (inputColumnVector2.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    if (outputColumnVector.isNull[i]) continue;
                    outputVector[i] = this.getResult(inputColumnVector1, i, inputColumnVector2, 0);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    if (outputColumnVector.isNull[i]) continue;
                    outputVector[i] = this.getResult(inputColumnVector1, i, inputColumnVector2, 0);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = selected[j];
                if (outputColumnVector.isNull[i]) continue;
                outputVector[i] = this.getResult(inputColumnVector1, i, inputColumnVector2, i);
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (outputColumnVector.isNull[i]) continue;
                outputVector[i] = this.getResult(inputColumnVector1, i, inputColumnVector2, i);
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("dataType", this.dataType.toString());
        trace.attribute("leftColumnNo", String.valueOf(this.leftColumnNo));
        trace.attribute("rightColumnNo", String.valueOf(this.rightColumnNo));
        trace.attribute("outputColumnNo", String.valueOf(this.outputColumnNo));
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }

    static {
        GC_VALUE.setFirstDayOfWeek(2);
        GC_VALUE.setMinimalDaysInFirstWeek(4);
        GC_VALUE.clear();
    }
}

