/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.DecimalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import java.math.BigDecimal;
import org.dom4j.Element;

public class XVectorDecimalColumnEqualsDecimalScalar
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int columnNo;
    private int outputColumnNo;
    private BigDecimal value;

    public XVectorDecimalColumnEqualsDecimalScalar() {
    }

    public XVectorDecimalColumnEqualsDecimalScalar(int inColNum, BigDecimal inValue, int inOutputColumnNo) {
        this.columnNo = inColNum;
        this.value = inValue;
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) throws XQERuntimeException {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        int[] selected = batch.selected;
        DecimalColumnVector inputColumnVector = (DecimalColumnVector)batch.columns[this.columnNo];
        LongColumnVector outputColumnVector = (LongColumnVector)batch.columns[this.outputColumnNo];
        BigDecimal[] vector = inputColumnVector.vector;
        boolean[] inputIsNull = inputColumnVector.isNull;
        long[] outputVector = outputColumnVector.vector;
        boolean[] outputIsNull = outputColumnVector.isNull;
        outputColumnVector.isRepeating = inputColumnVector.isRepeating;
        if (inputColumnVector.isRepeating) {
            outputVector[0] = vector[0].compareTo(this.value) == 0 ? 1L : 0L;
        } else if (inputColumnVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j < n; ++j) {
                    int i = selected[j];
                    outputVector[i] = vector[i].compareTo(this.value) == 0 ? 1L : 0L;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    outputVector[i] = vector[i].compareTo(this.value) == 0 ? 1L : 0L;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j < n; ++j) {
                int i = selected[j];
                if (!inputIsNull[i]) {
                    if (vector[i].compareTo(this.value) == 0) {
                        outputVector[i] = 1L;
                        continue;
                    }
                    outputVector[i] = 0L;
                    continue;
                }
                outputIsNull[i] = true;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (!inputIsNull[i]) {
                    if (vector[i].compareTo(this.value) == 0) {
                        outputVector[i] = 1L;
                        continue;
                    }
                    outputVector[i] = 0L;
                    continue;
                }
                outputIsNull[i] = true;
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", this.columnNo);
        trace.attribute("value", String.valueOf(this.value));
        trace.attribute("outputColumnNo", this.outputColumnNo);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.value = new BigDecimal(inputNode.attributeValue("value"));
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue("outputColumnNo"));
    }
}

