/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.DecimalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.NullUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import java.math.BigDecimal;
import org.dom4j.Element;

public class XVectorDecimalColumnLessThanOrEqualsDecimalColumn
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum1;
    private int colNum2;
    private int outputColumnNo;

    public XVectorDecimalColumnLessThanOrEqualsDecimalColumn() {
    }

    public XVectorDecimalColumnLessThanOrEqualsDecimalColumn(int inColNum1, int inColNum2, int inOutputColumnNo) {
        this.colNum1 = inColNum1;
        this.colNum2 = inColNum2;
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) throws XQERuntimeException {
        block18: {
            boolean[] isNull;
            BigDecimal[] vector2;
            BigDecimal[] vector1;
            DecimalColumnVector inputColVector2;
            DecimalColumnVector inputColVector1;
            int[] selected;
            int n;
            block17: {
                super.evaluate(context, batch);
                n = batch.size;
                if (n == 0) {
                    return;
                }
                selected = batch.selected;
                inputColVector1 = (DecimalColumnVector)batch.columns[this.colNum1];
                inputColVector2 = (DecimalColumnVector)batch.columns[this.colNum2];
                LongColumnVector outputColumnVector = (LongColumnVector)batch.columns[this.outputColumnNo];
                vector1 = inputColVector1.vector;
                vector2 = inputColVector2.vector;
                long[] outputVector = outputColumnVector.vector;
                isNull = outputColumnVector.isNull;
                NullUtil.propagateNulls(inputColVector1, inputColVector2, outputColumnVector, selected, n, batch.selectedInUse);
                if (n == 0 || !inputColVector1.isRepeating || !inputColVector2.isRepeating) break block17;
                outputColumnVector.isRepeating = true;
                if (isNull[0]) break block18;
                outputVector[0] = vector1[0].compareTo(vector2[0]) <= 0 ? 1L : 0L;
                break block18;
            }
            if (inputColVector1.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = selected[j];
                        if (isNull[i]) continue;
                        outputVector[i] = vector1[0].compareTo(vector2[i]) <= 0 ? 1L : 0L;
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        if (isNull[i]) continue;
                        outputVector[i] = vector1[0].compareTo(vector2[i]) <= 0 ? 1L : 0L;
                    }
                }
            } else if (inputColVector2.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = selected[j];
                        if (isNull[i]) continue;
                        outputVector[i] = vector1[i].compareTo(vector2[0]) <= 0 ? 1L : 0L;
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        if (isNull[i]) continue;
                        outputVector[i] = vector1[i].compareTo(vector2[0]) <= 0 ? 1L : 0L;
                    }
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    if (isNull[i]) continue;
                    outputVector[i] = vector1[i].compareTo(vector2[i]) <= 0 ? 1L : 0L;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    if (isNull[i]) continue;
                    outputVector[i] = vector1[i].compareTo(vector2[i]) <= 0 ? 1L : 0L;
                }
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("leftColumnNo", this.colNum1);
        trace.attribute("rightColumnNo", this.colNum2);
        trace.attribute("outputColumnNo", this.outputColumnNo);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.colNum1 = Integer.valueOf(inputNode.attributeValue("leftColumnNo"));
        this.colNum2 = Integer.valueOf(inputNode.attributeValue("rightColumnNo"));
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue("outputColumnNo"));
        super.capture(env, inputNode);
    }
}

