/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.DecimalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.DecimalUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import java.math.BigDecimal;
import org.dom4j.Element;

public class XVectorDecimalColumnSafeDivideDecimalScalar
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int columnNo;
    private int outputColumnNo;
    private BigDecimal value;

    public XVectorDecimalColumnSafeDivideDecimalScalar() {
    }

    public XVectorDecimalColumnSafeDivideDecimalScalar(int inColumnNo, Number inValue, int inOutputColumnNo) {
        this.columnNo = inColumnNo;
        this.value = DecimalUtil.getDecimalValue(inValue);
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) throws XQERuntimeException {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        DecimalColumnVector inputColumnVector = (DecimalColumnVector)batch.columns[this.columnNo];
        DecimalColumnVector outputColumnVector = (DecimalColumnVector)batch.columns[this.outputColumnNo];
        int[] selected = batch.selected;
        boolean[] inputIsNull = inputColumnVector.isNull;
        boolean[] outputIsNull = outputColumnVector.isNull;
        BigDecimal[] vector = inputColumnVector.vector;
        outputColumnVector.noNulls = inputColumnVector.noNulls;
        outputColumnVector.isRepeating = inputColumnVector.isRepeating;
        if (this.value.compareTo(BigDecimal.ZERO) == 0) {
            outputColumnVector.noNulls = false;
            outputColumnVector.isRepeating = true;
            outputIsNull[0] = true;
        } else if (inputColumnVector.isRepeating) {
            DecimalUtil.divideChecked(0, vector[0], this.value, outputColumnVector);
            outputIsNull[0] = inputIsNull[0];
        } else if (inputColumnVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    DecimalUtil.divideChecked(i, vector[i], this.value, outputColumnVector);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    DecimalUtil.divideChecked(i, vector[i], this.value, outputColumnVector);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = selected[j];
                DecimalUtil.divideChecked(i, vector[i], this.value, outputColumnVector);
                outputIsNull[i] = inputIsNull[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                DecimalUtil.divideChecked(i, vector[i], this.value, outputColumnVector);
            }
            System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", this.columnNo);
        trace.attribute("value", String.valueOf(this.value));
        trace.attribute("outputColumnNo", this.outputColumnNo);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.value = new BigDecimal(inputNode.attributeValue("value"));
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue("outputColumnNo"));
        this.setDataType(DataTypeFactory.getType(inputNode.attribute("dataType").getValue()));
        super.capture(env, inputNode);
    }
}

