/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.DoubleColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.NullUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class XVectorDoubleColumnAddLongColumn
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum1;
    private int colNum2;
    private int outputColumnNo;

    public XVectorDoubleColumnAddLongColumn() {
    }

    public XVectorDoubleColumnAddLongColumn(int inColNum1, int inColNum2, int inOutputColumnNo) {
        this.colNum1 = inColNum1;
        this.colNum2 = inColNum2;
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) throws XQERuntimeException {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        DoubleColumnVector inputColumnVector1 = (DoubleColumnVector)batch.columns[this.colNum1];
        LongColumnVector inputColumnVector2 = (LongColumnVector)batch.columns[this.colNum2];
        DoubleColumnVector outputColumnVector = (DoubleColumnVector)batch.columns[this.outputColumnNo];
        if (outputColumnVector.getFormatId() == FormatId.INVALID_FORMAT_FID) {
            outputColumnVector.setFormatID("Add", inputColumnVector1.getFormatId(), inputColumnVector2.getFormatId());
        }
        int[] selected = batch.selected;
        double[] vector1 = inputColumnVector1.vector;
        long[] vector2 = inputColumnVector2.vector;
        double[] outputVector = outputColumnVector.vector;
        outputColumnVector.isRepeating = inputColumnVector1.isRepeating && inputColumnVector2.isRepeating || inputColumnVector1.isRepeating && !inputColumnVector1.noNulls && inputColumnVector1.isNull[0] || inputColumnVector2.isRepeating && !inputColumnVector2.noNulls && inputColumnVector2.isNull[0];
        NullUtil.propagateNulls(inputColumnVector1, inputColumnVector2, outputColumnVector, selected, n, batch.selectedInUse);
        if (inputColumnVector1.isRepeating && inputColumnVector2.isRepeating) {
            outputVector[0] = vector1[0] + (double)vector2[0];
        } else if (inputColumnVector1.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputVector[i] = vector1[0] + (double)vector2[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = vector1[0] + (double)vector2[i];
                }
            }
        } else if (inputColumnVector2.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputVector[i] = vector1[i] + (double)vector2[0];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = vector1[i] + (double)vector2[0];
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = selected[j];
                outputVector[i] = vector1[i] + (double)vector2[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                outputVector[i] = vector1[i] + (double)vector2[i];
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public String getOutputType() {
        return "double";
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("leftColumnNo", this.colNum1);
        trace.attribute("rightColumnNo", this.colNum2);
        trace.attribute("outputColumnNo", this.outputColumnNo);
        trace.attribute("dataType", this.dataType.toString());
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.dataType = DataTypeFactory.getType(inputNode.attribute("dataType").getValue());
        this.colNum1 = Integer.valueOf(inputNode.attributeValue("leftColumnNo"));
        this.colNum2 = Integer.valueOf(inputNode.attributeValue("rightColumnNo"));
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue("outputColumnNo"));
        super.capture(env, inputNode);
    }
}

