/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.DoubleColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class XVectorDoubleColumnBetween
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_COLUMNNO = "columnNo";
    private static final String ATTRIBUTE_LEFTVALUE = "leftValue";
    private static final String ATTRIBUTE_RIGHTVALUE = "rightValue";
    private int columnNo;
    private double leftValue;
    private double rightValue;
    private int outputColumnNo;

    public XVectorDoubleColumnBetween(int theColumnNo, Number theLeftValue, Number theRightValue, int theOutputColumnNo) {
        this.columnNo = theColumnNo;
        this.leftValue = theLeftValue.doubleValue();
        this.rightValue = theRightValue.doubleValue();
        this.outputColumnNo = theOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        int[] selected = batch.selected;
        DoubleColumnVector inputColVector = (DoubleColumnVector)batch.columns[this.columnNo];
        LongColumnVector outputColumnVector = (LongColumnVector)batch.columns[this.outputColumnNo];
        boolean[] inputIsNull = inputColVector.isNull;
        double[] vector = inputColVector.vector;
        long[] outputVector = outputColumnVector.vector;
        outputColumnVector.isRepeating = inputColVector.isRepeating;
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                outputVector[0] = vector[0] >= this.leftValue && vector[0] <= this.rightValue ? 1L : 0L;
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputVector[i] = vector[i] >= this.leftValue && vector[i] <= this.rightValue ? 1L : 0L;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = vector[i] >= this.leftValue && vector[i] <= this.rightValue ? 1L : 0L;
                }
            }
        } else if (inputColVector.isRepeating) {
            outputVector[0] = !inputIsNull[0] ? (vector[0] >= this.leftValue && vector[0] <= this.rightValue ? 1L : 0L) : 0L;
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = selected[j];
                if (!inputIsNull[i]) {
                    if (vector[i] >= this.leftValue && vector[i] <= this.rightValue) {
                        outputVector[i] = 1L;
                        continue;
                    }
                    outputVector[i] = 0L;
                    continue;
                }
                outputVector[i] = 0L;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!inputIsNull[i]) {
                    if (vector[i] >= this.leftValue && vector[i] <= this.rightValue) {
                        outputVector[i] = 1L;
                        continue;
                    }
                    outputVector[i] = 0L;
                    continue;
                }
                outputVector[i] = 0L;
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_COLUMNNO, this.columnNo);
        trace.attribute(ATTRIBUTE_LEFTVALUE, String.valueOf(this.leftValue));
        trace.attribute(ATTRIBUTE_RIGHTVALUE, String.valueOf(this.rightValue));
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue(ATTRIBUTE_COLUMNNO));
        this.leftValue = Long.valueOf(inputNode.attributeValue(ATTRIBUTE_LEFTVALUE)).longValue();
        this.rightValue = Long.valueOf(inputNode.attributeValue(ATTRIBUTE_RIGHTVALUE)).longValue();
        super.capture(env, inputNode);
    }
}

