/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class XVectorDoubleScalarGreaterThanOrEqualsLongColumn
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int columnNo;
    private double value;
    private int outputColumnNo;

    public XVectorDoubleScalarGreaterThanOrEqualsLongColumn() {
    }

    public XVectorDoubleScalarGreaterThanOrEqualsLongColumn(Number inValue, int inColumnNo, int inOutputColumnNo) {
        this.columnNo = inColumnNo;
        this.value = inValue.doubleValue();
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) throws XQERuntimeException {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        int[] selected = batch.selected;
        LongColumnVector inputColumnVector = (LongColumnVector)batch.columns[this.columnNo];
        boolean[] isNull = inputColumnVector.isNull;
        long[] vector = inputColumnVector.vector;
        LongColumnVector outputColumnVector = (LongColumnVector)batch.columns[this.outputColumnNo];
        boolean[] outputIsNull = outputColumnVector.isNull;
        long[] outputVector = outputColumnVector.vector;
        outputColumnVector.isRepeating = inputColumnVector.isRepeating;
        if (inputColumnVector.noNulls) {
            if (inputColumnVector.isRepeating) {
                outputVector[0] = this.value >= (double)vector[0] ? 1L : 0L;
            } else if (batch.selectedInUse) {
                for (int j = 0; j < n; ++j) {
                    int i = selected[j];
                    outputVector[i] = this.value >= (double)vector[i] ? 1L : 0L;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    outputVector[i] = this.value >= (double)vector[i] ? 1L : 0L;
                }
            }
        } else if (inputColumnVector.isRepeating) {
            if (!isNull[0]) {
                outputVector[0] = this.value >= (double)vector[0] ? 1L : 0L;
                outputIsNull[0] = false;
            } else {
                outputIsNull[0] = true;
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j < n; ++j) {
                int i = selected[j];
                if (!isNull[i]) {
                    outputVector[i] = this.value >= (double)vector[i] ? 1L : 0L;
                    outputIsNull[i] = false;
                    continue;
                }
                outputIsNull[i] = true;
            }
        } else {
            System.arraycopy(isNull, 0, outputIsNull, 0, n);
            for (int i = 0; i < n; ++i) {
                if (isNull[i]) continue;
                outputVector[i] = this.value >= (double)vector[i] ? 1L : 0L;
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", this.columnNo);
        trace.attribute("value", String.valueOf(this.value));
        trace.attribute("outputColumnNo", this.outputColumnNo);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.dataType = DataTypeFactory.getType(inputNode.attribute("dataType").getValue());
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.value = Double.valueOf(inputNode.attributeValue("value"));
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue("outputColumnNo"));
    }
}

