/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.DecimalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.DecimalUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import com.ibm.icu.text.Collator;
import java.math.BigDecimal;
import org.dom4j.Element;

public class XVectorFilterDecimalColumnNotBetween
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_LEFTVALUE = "leftValue";
    private static final String ATTRIBUTE_RIGHTVALUE = "rightValue";
    private int columnNo;
    private BigDecimal leftValue;
    private BigDecimal rightValue;

    public XVectorFilterDecimalColumnNotBetween(int theColumnNo, Number theLeftValue, Number theRightValue) {
        this.columnNo = theColumnNo;
        this.leftValue = DecimalUtil.getDecimalValue(theLeftValue);
        this.rightValue = DecimalUtil.getDecimalValue(theRightValue);
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) throws XQERuntimeException {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        Collator collator = context.getLocalCollator();
        int[] selected = batch.selected;
        DecimalColumnVector inputColumnVector = (DecimalColumnVector)batch.columns[this.columnNo];
        boolean[] isNull = inputColumnVector.isNull;
        BigDecimal[] vector = inputColumnVector.vector;
        if (inputColumnVector.noNulls) {
            if (inputColumnVector.isRepeating) {
                if (vector[0].compareTo(this.leftValue) < 0 || vector[0].compareTo(this.rightValue) > 0) {
                    batch.size = 0;
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j < n; ++j) {
                    int i = selected[j];
                    if (vector[i].compareTo(this.leftValue) >= 0 && vector[i].compareTo(this.rightValue) <= 0) continue;
                    selected[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            } else {
                int newSize = 0;
                for (int i = 0; i < n; ++i) {
                    if (vector[i].compareTo(this.leftValue) >= 0 && vector[i].compareTo(this.rightValue) <= 0) continue;
                    selected[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColumnVector.isRepeating) {
            if (!isNull[0]) {
                if (vector[0].compareTo(this.leftValue) < 0 || vector[0].compareTo(this.rightValue) > 0) {
                    batch.size = 0;
                }
            } else {
                batch.size = 0;
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j < n; ++j) {
                int i = selected[j];
                if (isNull[i] || vector[i].compareTo(this.leftValue) >= 0 && vector[i].compareTo(this.rightValue) <= 0) continue;
                selected[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        } else {
            int newSize = 0;
            for (int i = 0; i < n; ++i) {
                if (isNull[i] || vector[i].compareTo(this.leftValue) >= 0 && vector[i].compareTo(this.rightValue) <= 0) continue;
                selected[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", this.columnNo);
        trace.attribute(ATTRIBUTE_LEFTVALUE, this.leftValue.toString());
        trace.attribute(ATTRIBUTE_RIGHTVALUE, this.rightValue.toString());
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.leftValue = new BigDecimal(inputNode.attributeValue(ATTRIBUTE_LEFTVALUE));
        this.rightValue = new BigDecimal(inputNode.attributeValue(ATTRIBUTE_RIGHTVALUE));
        super.capture(env, inputNode);
    }
}

